
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Scheduler.i,v 1.8 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_scheduler_i
#define quantlib_scheduler_i

%include Date.i
%include Calendars.i

%{
using QuantLib::Scheduler;
%}

class Scheduler {
  public:
    Scheduler(Calendar calendar, Date startDate, Date endDate,
      int frequency, RollingConvention rollingConvention, bool isAdjusted,
      Date stubDate);
    ~Scheduler();
    // inspectors
    int size() const;
    Date date(int i) const;
    bool isRegular(int i) const;
};


#endif
