
#line 1 "hb-ot-shape-complex-indic-machine.rl"
/*
 * Copyright © 2011,2012  Google, Inc.
 *
 *  This is part of HarfBuzz, a text shaping library.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 * Google Author(s): Behdad Esfahbod
 */

#ifndef HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH
#define HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH

#include "hb-private.hh"


#line 36 "hb-ot-shape-complex-indic-machine.hh"
static const unsigned char _indic_syllable_machine_trans_keys[] = {
	1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 
	7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 
	5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 
	4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 1u, 16u, 13u, 13u, 5u, 7u, 5u, 7u, 7u, 7u, 
	5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 4u, 4u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 4u, 14u, 
	4u, 14u, 5u, 7u, 5u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 5u, 7u, 5u, 7u, 
	7u, 7u, 5u, 7u, 5u, 7u, 7u, 7u, 1u, 16u, 13u, 13u, 4u, 4u, 6u, 6u, 
	16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 6u, 6u, 16u, 16u, 4u, 7u, 
	6u, 6u, 16u, 16u, 1u, 31u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 18u, 8u, 18u, 
	5u, 10u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 18u, 3u, 18u, 8u, 18u, 
	3u, 10u, 8u, 10u, 3u, 18u, 3u, 18u, 3u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 
	3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 
	6u, 18u, 3u, 18u, 1u, 18u, 4u, 31u, 4u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 
	1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 
	1u, 18u, 1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 
	1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 
	1u, 18u, 3u, 31u, 3u, 31u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 18u, 8u, 18u, 
	5u, 10u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 18u, 3u, 18u, 8u, 18u, 
	3u, 10u, 8u, 10u, 3u, 18u, 3u, 18u, 3u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 
	3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 
	6u, 18u, 3u, 18u, 1u, 18u, 4u, 31u, 4u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 
	1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 
	1u, 18u, 1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 
	1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 
	4u, 14u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 
	4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 
	4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 18u, 8u, 18u, 5u, 10u, 
	9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 18u, 3u, 18u, 8u, 18u, 3u, 10u, 
	8u, 10u, 3u, 18u, 3u, 18u, 3u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 
	4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 6u, 18u, 
	3u, 18u, 1u, 18u, 4u, 31u, 4u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 
	1u, 18u, 1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 
	1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 
	1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 
	4u, 14u, 3u, 31u, 4u, 14u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 
	3u, 31u, 4u, 31u, 1u, 18u, 3u, 31u, 3u, 31u, 4u, 31u, 5u, 18u, 8u, 18u, 
	5u, 10u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 18u, 3u, 18u, 8u, 18u, 
	3u, 10u, 8u, 10u, 3u, 18u, 3u, 18u, 3u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 
	3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 
	6u, 18u, 3u, 18u, 1u, 18u, 4u, 31u, 4u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 
	1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 
	1u, 18u, 1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 
	1u, 18u, 1u, 18u, 3u, 31u, 3u, 31u, 1u, 18u, 1u, 18u, 1u, 18u, 1u, 18u, 
	1u, 18u, 3u, 31u, 1u, 31u, 3u, 31u, 1u, 31u, 4u, 18u, 1u, 18u, 3u, 31u, 
	3u, 31u, 4u, 31u, 5u, 10u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 3u, 10u, 
	8u, 10u, 3u, 31u, 3u, 31u, 1u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 
	4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 5u, 18u, 3u, 18u, 4u, 18u, 8u, 18u, 
	3u, 18u, 3u, 18u, 8u, 18u, 3u, 18u, 3u, 18u, 1u, 18u, 3u, 10u, 8u, 10u, 
	5u, 10u, 9u, 10u, 9u, 10u, 9u, 9u, 5u, 10u, 0
};

static const char _indic_syllable_machine_key_spans[] = {
	16, 1, 3, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 16, 1, 3, 3, 
	1, 3, 3, 1, 3, 3, 1, 3, 
	3, 1, 1, 1, 1, 4, 1, 1, 
	4, 1, 1, 4, 1, 1, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	16, 1, 3, 3, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 16, 1, 3, 3, 1, 
	3, 3, 1, 3, 3, 1, 3, 3, 
	1, 1, 1, 1, 4, 1, 1, 4, 
	1, 1, 4, 1, 1, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 3, 3, 3, 3, 1, 3, 3, 
	1, 3, 3, 1, 16, 1, 1, 1, 
	1, 4, 1, 1, 4, 1, 1, 4, 
	1, 1, 31, 29, 29, 28, 18, 29, 
	29, 28, 18, 29, 29, 28, 18, 29, 
	29, 28, 18, 29, 29, 28, 14, 11, 
	6, 2, 2, 1, 6, 16, 16, 11, 
	8, 3, 16, 16, 16, 16, 15, 14, 
	16, 15, 14, 16, 15, 14, 16, 15, 
	13, 16, 18, 28, 15, 29, 29, 18, 
	18, 18, 18, 18, 29, 29, 18, 18, 
	18, 18, 18, 29, 29, 18, 18, 18, 
	18, 18, 29, 29, 18, 18, 18, 18, 
	18, 29, 29, 29, 29, 28, 18, 29, 
	29, 28, 18, 29, 29, 28, 18, 29, 
	29, 28, 18, 29, 29, 28, 14, 11, 
	6, 2, 2, 1, 6, 16, 16, 11, 
	8, 3, 16, 16, 16, 16, 15, 14, 
	16, 15, 14, 16, 15, 14, 16, 15, 
	13, 16, 18, 28, 15, 29, 29, 18, 
	18, 18, 18, 18, 29, 29, 18, 18, 
	18, 18, 18, 29, 29, 18, 18, 18, 
	18, 18, 29, 29, 18, 18, 18, 18, 
	11, 18, 29, 29, 28, 18, 29, 29, 
	28, 18, 29, 29, 28, 18, 29, 29, 
	28, 18, 29, 29, 28, 14, 11, 6, 
	2, 2, 1, 6, 16, 16, 11, 8, 
	3, 16, 16, 16, 16, 15, 14, 16, 
	15, 14, 16, 15, 14, 16, 15, 13, 
	16, 18, 28, 15, 29, 29, 18, 18, 
	18, 18, 18, 29, 29, 18, 18, 18, 
	18, 18, 29, 29, 18, 18, 18, 18, 
	18, 29, 29, 18, 18, 18, 18, 18, 
	11, 29, 11, 29, 29, 28, 18, 29, 
	29, 28, 18, 29, 29, 28, 18, 29, 
	29, 28, 18, 29, 29, 28, 14, 11, 
	6, 2, 2, 1, 6, 16, 16, 11, 
	8, 3, 16, 16, 16, 16, 15, 14, 
	16, 15, 14, 16, 15, 14, 16, 15, 
	13, 16, 18, 28, 15, 29, 29, 18, 
	18, 18, 18, 18, 29, 29, 18, 18, 
	18, 18, 18, 29, 29, 18, 18, 18, 
	18, 18, 29, 29, 18, 18, 18, 18, 
	18, 29, 31, 29, 31, 15, 18, 29, 
	29, 28, 6, 2, 2, 1, 6, 8, 
	3, 29, 29, 18, 16, 15, 14, 16, 
	15, 14, 16, 15, 14, 16, 15, 11, 
	16, 16, 11, 16, 16, 18, 8, 3, 
	6, 2, 2, 1, 6
};

static const short _indic_syllable_machine_index_offsets[] = {
	0, 17, 19, 23, 27, 29, 33, 37, 
	39, 43, 47, 49, 53, 57, 59, 61, 
	63, 65, 70, 72, 74, 79, 81, 83, 
	88, 90, 92, 104, 116, 128, 140, 152, 
	164, 176, 188, 200, 212, 229, 231, 235, 
	239, 241, 245, 249, 251, 255, 259, 261, 
	265, 269, 271, 273, 275, 277, 282, 284, 
	286, 291, 293, 295, 300, 302, 304, 316, 
	328, 340, 352, 364, 376, 388, 400, 412, 
	424, 441, 443, 447, 451, 453, 457, 461, 
	463, 467, 471, 473, 477, 481, 483, 485, 
	487, 489, 494, 496, 498, 503, 505, 507, 
	512, 514, 516, 528, 540, 552, 564, 576, 
	588, 600, 612, 624, 641, 643, 647, 651, 
	653, 657, 661, 663, 667, 671, 673, 677, 
	681, 683, 685, 687, 689, 694, 696, 698, 
	703, 705, 707, 712, 714, 716, 728, 740, 
	752, 764, 776, 788, 800, 812, 824, 836, 
	848, 860, 864, 868, 872, 876, 878, 882, 
	886, 888, 892, 896, 898, 915, 917, 919, 
	921, 923, 928, 930, 932, 937, 939, 941, 
	946, 948, 950, 982, 1012, 1042, 1071, 1090, 
	1120, 1150, 1179, 1198, 1228, 1258, 1287, 1306, 
	1336, 1366, 1395, 1414, 1444, 1474, 1503, 1518, 
	1530, 1537, 1540, 1543, 1545, 1552, 1569, 1586, 
	1598, 1607, 1611, 1628, 1645, 1662, 1679, 1695, 
	1710, 1727, 1743, 1758, 1775, 1791, 1806, 1823, 
	1839, 1853, 1870, 1889, 1918, 1934, 1964, 1994, 
	2013, 2032, 2051, 2070, 2089, 2119, 2149, 2168, 
	2187, 2206, 2225, 2244, 2274, 2304, 2323, 2342, 
	2361, 2380, 2399, 2429, 2459, 2478, 2497, 2516, 
	2535, 2554, 2584, 2614, 2644, 2674, 2703, 2722, 
	2752, 2782, 2811, 2830, 2860, 2890, 2919, 2938, 
	2968, 2998, 3027, 3046, 3076, 3106, 3135, 3150, 
	3162, 3169, 3172, 3175, 3177, 3184, 3201, 3218, 
	3230, 3239, 3243, 3260, 3277, 3294, 3311, 3327, 
	3342, 3359, 3375, 3390, 3407, 3423, 3438, 3455, 
	3471, 3485, 3502, 3521, 3550, 3566, 3596, 3626, 
	3645, 3664, 3683, 3702, 3721, 3751, 3781, 3800, 
	3819, 3838, 3857, 3876, 3906, 3936, 3955, 3974, 
	3993, 4012, 4031, 4061, 4091, 4110, 4129, 4148, 
	4167, 4179, 4198, 4228, 4258, 4287, 4306, 4336, 
	4366, 4395, 4414, 4444, 4474, 4503, 4522, 4552, 
	4582, 4611, 4630, 4660, 4690, 4719, 4734, 4746, 
	4753, 4756, 4759, 4761, 4768, 4785, 4802, 4814, 
	4823, 4827, 4844, 4861, 4878, 4895, 4911, 4926, 
	4943, 4959, 4974, 4991, 5007, 5022, 5039, 5055, 
	5069, 5086, 5105, 5134, 5150, 5180, 5210, 5229, 
	5248, 5267, 5286, 5305, 5335, 5365, 5384, 5403, 
	5422, 5441, 5460, 5490, 5520, 5539, 5558, 5577, 
	5596, 5615, 5645, 5675, 5694, 5713, 5732, 5751, 
	5770, 5782, 5812, 5824, 5854, 5884, 5913, 5932, 
	5962, 5992, 6021, 6040, 6070, 6100, 6129, 6148, 
	6178, 6208, 6237, 6256, 6286, 6316, 6345, 6360, 
	6372, 6379, 6382, 6385, 6387, 6394, 6411, 6428, 
	6440, 6449, 6453, 6470, 6487, 6504, 6521, 6537, 
	6552, 6569, 6585, 6600, 6617, 6633, 6648, 6665, 
	6681, 6695, 6712, 6731, 6760, 6776, 6806, 6836, 
	6855, 6874, 6893, 6912, 6931, 6961, 6991, 7010, 
	7029, 7048, 7067, 7086, 7116, 7146, 7165, 7184, 
	7203, 7222, 7241, 7271, 7301, 7320, 7339, 7358, 
	7377, 7396, 7426, 7458, 7488, 7520, 7536, 7555, 
	7585, 7615, 7644, 7651, 7654, 7657, 7659, 7666, 
	7675, 7679, 7709, 7739, 7758, 7775, 7791, 7806, 
	7823, 7839, 7854, 7871, 7887, 7902, 7919, 7935, 
	7947, 7964, 7981, 7993, 8010, 8027, 8046, 8055, 
	8059, 8066, 8069, 8072, 8074
};

static const short _indic_syllable_machine_indicies[] = {
	1, 2, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 3, 0, 4, 4, 5, 0, 6, 
	6, 5, 0, 5, 0, 7, 7, 8, 
	0, 9, 9, 8, 0, 8, 0, 10, 
	10, 11, 0, 12, 12, 11, 0, 11, 
	0, 13, 13, 14, 0, 15, 15, 14, 
	0, 14, 0, 16, 0, 17, 0, 18, 
	0, 19, 13, 13, 14, 0, 20, 0, 
	21, 0, 22, 10, 10, 11, 0, 23, 
	0, 24, 0, 25, 7, 7, 8, 0, 
	26, 0, 27, 0, 28, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 28, 0, 
	28, 4, 4, 5, 0, 0, 0, 0, 
	0, 29, 28, 0, 30, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 30, 0, 
	30, 4, 4, 5, 0, 0, 0, 0, 
	0, 31, 30, 0, 32, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 32, 0, 
	32, 4, 4, 5, 0, 0, 0, 0, 
	0, 33, 32, 0, 34, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 34, 0, 
	34, 4, 4, 5, 0, 0, 0, 0, 
	0, 35, 34, 0, 36, 4, 4, 5, 
	0, 0, 0, 0, 0, 0, 36, 0, 
	36, 4, 4, 5, 0, 0, 0, 0, 
	0, 37, 36, 0, 39, 40, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 39, 38, 41, 38, 42, 
	42, 43, 38, 44, 44, 43, 38, 43, 
	38, 45, 45, 46, 38, 47, 47, 46, 
	38, 46, 38, 48, 48, 49, 38, 50, 
	50, 49, 38, 49, 38, 51, 51, 52, 
	38, 53, 53, 52, 38, 52, 38, 54, 
	38, 55, 38, 56, 38, 57, 51, 51, 
	52, 38, 58, 38, 59, 38, 60, 48, 
	48, 49, 38, 61, 38, 62, 38, 63, 
	45, 45, 46, 38, 64, 38, 65, 38, 
	66, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 66, 38, 66, 42, 42, 43, 
	38, 38, 38, 38, 38, 67, 66, 38, 
	68, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 68, 38, 68, 42, 42, 43, 
	38, 38, 38, 38, 38, 69, 68, 38, 
	70, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 70, 38, 70, 42, 42, 43, 
	38, 38, 38, 38, 38, 71, 70, 38, 
	72, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 72, 38, 72, 42, 42, 43, 
	38, 38, 38, 38, 38, 73, 72, 38, 
	74, 42, 42, 43, 38, 38, 38, 38, 
	38, 38, 74, 38, 74, 42, 42, 43, 
	38, 38, 38, 38, 38, 75, 74, 38, 
	77, 78, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 77, 
	76, 79, 76, 80, 80, 81, 76, 83, 
	83, 81, 82, 81, 82, 84, 84, 85, 
	76, 86, 86, 85, 76, 85, 76, 87, 
	87, 88, 76, 89, 89, 88, 76, 88, 
	76, 90, 90, 91, 76, 92, 92, 91, 
	76, 91, 76, 93, 76, 94, 76, 95, 
	76, 96, 90, 90, 91, 76, 97, 76, 
	98, 76, 99, 87, 87, 88, 76, 100, 
	76, 101, 76, 102, 84, 84, 85, 76, 
	103, 76, 104, 76, 105, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 105, 76, 
	105, 80, 80, 81, 76, 76, 76, 76, 
	76, 106, 105, 76, 107, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 107, 76, 
	107, 80, 80, 81, 76, 76, 76, 76, 
	76, 108, 107, 76, 109, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 109, 76, 
	109, 80, 80, 81, 76, 76, 76, 76, 
	76, 110, 109, 76, 111, 80, 80, 81, 
	82, 82, 82, 82, 82, 82, 111, 82, 
	111, 80, 80, 81, 76, 76, 76, 76, 
	76, 112, 111, 76, 113, 80, 80, 81, 
	76, 76, 76, 76, 76, 76, 113, 76, 
	115, 116, 114, 114, 114, 114, 114, 114, 
	114, 114, 114, 114, 114, 114, 114, 115, 
	114, 117, 114, 118, 118, 119, 114, 120, 
	120, 119, 114, 119, 114, 121, 121, 122, 
	114, 123, 123, 122, 114, 122, 114, 124, 
	124, 125, 114, 126, 126, 125, 114, 125, 
	114, 127, 127, 128, 114, 129, 129, 128, 
	114, 128, 114, 130, 114, 131, 114, 132, 
	114, 133, 127, 127, 128, 114, 134, 114, 
	135, 114, 136, 124, 124, 125, 114, 137, 
	114, 138, 114, 139, 121, 121, 122, 114, 
	140, 114, 141, 114, 142, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 142, 114, 
	142, 118, 118, 119, 114, 114, 114, 114, 
	114, 143, 142, 114, 144, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 144, 114, 
	144, 118, 118, 119, 114, 114, 114, 114, 
	114, 145, 144, 114, 146, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 146, 114, 
	146, 118, 118, 119, 114, 114, 114, 114, 
	114, 147, 146, 114, 148, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 148, 114, 
	148, 118, 118, 119, 114, 114, 114, 114, 
	114, 149, 148, 114, 150, 118, 118, 119, 
	114, 114, 114, 114, 114, 114, 150, 114, 
	150, 118, 118, 119, 114, 114, 114, 114, 
	114, 151, 150, 114, 113, 80, 80, 81, 
	76, 76, 76, 76, 76, 152, 113, 76, 
	111, 80, 80, 81, 0, 0, 0, 0, 
	0, 153, 111, 0, 154, 154, 155, 0, 
	6, 6, 155, 0, 156, 156, 157, 0, 
	158, 158, 157, 0, 157, 0, 159, 159, 
	160, 0, 161, 161, 160, 0, 160, 0, 
	162, 162, 163, 0, 164, 164, 163, 0, 
	163, 0, 165, 166, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 165, 0, 167, 0, 168, 0, 169, 
	0, 170, 0, 171, 162, 162, 163, 0, 
	172, 0, 173, 0, 174, 159, 159, 160, 
	0, 175, 0, 176, 0, 177, 156, 156, 
	157, 0, 178, 0, 179, 0, 181, 182, 
	183, 184, 185, 186, 81, 187, 188, 189, 
	190, 190, 152, 191, 192, 193, 194, 195, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 196, 180, 198, 199, 
	200, 201, 5, 202, 203, 204, 197, 197, 
	37, 205, 197, 197, 206, 207, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 208, 197, 209, 199, 210, 210, 
	5, 202, 203, 204, 197, 197, 197, 205, 
	197, 197, 206, 207, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	208, 197, 199, 210, 210, 5, 202, 203, 
	204, 197, 197, 197, 205, 197, 197, 206, 
	207, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 208, 197, 211, 
	197, 197, 197, 18, 212, 197, 202, 203, 
	204, 197, 197, 197, 213, 197, 211, 197, 
	207, 197, 214, 215, 216, 217, 5, 202, 
	203, 204, 197, 197, 35, 218, 197, 197, 
	206, 207, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 208, 197, 
	219, 215, 220, 220, 5, 202, 203, 204, 
	197, 197, 197, 218, 197, 197, 206, 207, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 208, 197, 215, 220, 
	220, 5, 202, 203, 204, 197, 197, 197, 
	218, 197, 197, 206, 207, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 208, 197, 221, 197, 197, 197, 18, 
	222, 197, 202, 203, 204, 197, 197, 197, 
	213, 197, 221, 197, 207, 197, 223, 224, 
	225, 226, 5, 202, 203, 204, 197, 197, 
	33, 227, 197, 197, 206, 207, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 208, 197, 228, 224, 229, 229, 
	5, 202, 203, 204, 197, 197, 197, 227, 
	197, 197, 206, 207, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	208, 197, 224, 229, 229, 5, 202, 203, 
	204, 197, 197, 197, 227, 197, 197, 206, 
	207, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 208, 197, 230, 
	197, 197, 197, 18, 231, 197, 202, 203, 
	204, 197, 197, 197, 213, 197, 230, 197, 
	207, 197, 232, 233, 234, 235, 5, 202, 
	203, 204, 197, 197, 31, 236, 197, 197, 
	206, 207, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 208, 197, 
	237, 233, 238, 238, 5, 202, 203, 204, 
	197, 197, 197, 236, 197, 197, 206, 207, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 208, 197, 233, 238, 
	238, 5, 202, 203, 204, 197, 197, 197, 
	236, 197, 197, 206, 207, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 208, 197, 239, 197, 197, 197, 18, 
	240, 197, 202, 203, 204, 197, 197, 197, 
	213, 197, 239, 197, 207, 197, 241, 242, 
	243, 244, 5, 202, 203, 204, 197, 197, 
	29, 245, 197, 197, 206, 207, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 208, 197, 246, 242, 247, 247, 
	5, 202, 203, 204, 197, 197, 197, 245, 
	197, 197, 206, 207, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	208, 197, 242, 247, 247, 5, 202, 203, 
	204, 197, 197, 197, 245, 197, 197, 206, 
	207, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 208, 197, 18, 
	248, 197, 202, 203, 204, 197, 197, 197, 
	213, 197, 197, 197, 207, 197, 202, 203, 
	204, 197, 197, 197, 213, 197, 197, 197, 
	207, 197, 249, 197, 197, 250, 203, 204, 
	197, 203, 204, 197, 203, 251, 197, 203, 
	197, 249, 197, 197, 197, 203, 204, 197, 
	252, 197, 253, 254, 197, 202, 203, 204, 
	197, 197, 3, 197, 197, 197, 197, 207, 
	197, 2, 197, 197, 197, 197, 202, 203, 
	204, 197, 197, 197, 197, 197, 197, 197, 
	207, 197, 202, 203, 204, 197, 197, 197, 
	197, 197, 197, 197, 207, 197, 255, 197, 
	197, 197, 197, 202, 203, 204, 197, 202, 
	203, 204, 197, 252, 197, 197, 197, 197, 
	202, 203, 204, 197, 197, 197, 197, 197, 
	197, 197, 207, 197, 252, 197, 253, 197, 
	197, 202, 203, 204, 197, 197, 3, 197, 
	197, 197, 197, 207, 197, 18, 197, 256, 
	256, 5, 202, 203, 204, 197, 197, 197, 
	213, 197, 197, 197, 207, 197, 257, 27, 
	258, 259, 8, 202, 203, 204, 197, 197, 
	197, 213, 197, 197, 197, 207, 197, 27, 
	258, 259, 8, 202, 203, 204, 197, 197, 
	197, 213, 197, 197, 197, 207, 197, 258, 
	258, 8, 202, 203, 204, 197, 197, 197, 
	213, 197, 197, 197, 207, 197, 260, 24, 
	261, 262, 11, 202, 203, 204, 197, 197, 
	197, 213, 197, 197, 197, 207, 197, 24, 
	261, 262, 11, 202, 203, 204, 197, 197, 
	197, 213, 197, 197, 197, 207, 197, 261, 
	261, 11, 202, 203, 204, 197, 197, 197, 
	213, 197, 197, 197, 207, 197, 263, 21, 
	264, 265, 14, 202, 203, 204, 197, 197, 
	197, 213, 197, 197, 197, 207, 197, 21, 
	264, 265, 14, 202, 203, 204, 197, 197, 
	197, 213, 197, 197, 197, 207, 197, 264, 
	264, 14, 202, 203, 204, 197, 197, 197, 
	213, 197, 197, 197, 207, 197, 266, 18, 
	197, 267, 197, 202, 203, 204, 197, 197, 
	197, 213, 197, 197, 197, 207, 197, 18, 
	197, 267, 197, 202, 203, 204, 197, 197, 
	197, 213, 197, 197, 197, 207, 197, 268, 
	197, 202, 203, 204, 197, 197, 197, 213, 
	197, 197, 197, 207, 197, 18, 197, 197, 
	197, 197, 202, 203, 204, 197, 197, 197, 
	213, 197, 197, 197, 207, 197, 1, 2, 
	197, 197, 18, 248, 197, 202, 203, 204, 
	197, 197, 197, 213, 197, 1, 197, 207, 
	197, 242, 247, 247, 5, 202, 203, 204, 
	197, 197, 197, 245, 197, 197, 197, 207, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 208, 197, 242, 247, 
	247, 5, 202, 203, 204, 197, 197, 197, 
	245, 197, 197, 197, 207, 197, 241, 242, 
	247, 247, 5, 202, 203, 204, 197, 197, 
	197, 245, 197, 197, 206, 207, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 208, 197, 241, 242, 243, 247, 
	5, 202, 203, 204, 197, 197, 29, 245, 
	197, 197, 206, 207, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	208, 197, 239, 197, 269, 197, 256, 256, 
	5, 202, 203, 204, 197, 197, 197, 213, 
	197, 239, 197, 207, 197, 239, 197, 197, 
	197, 197, 197, 197, 202, 203, 204, 197, 
	197, 197, 213, 197, 239, 197, 207, 197, 
	239, 197, 197, 197, 197, 270, 197, 202, 
	203, 204, 197, 197, 197, 213, 197, 239, 
	197, 207, 197, 239, 197, 269, 197, 197, 
	197, 197, 202, 203, 204, 197, 197, 197, 
	213, 197, 239, 197, 207, 197, 239, 2, 
	197, 197, 18, 240, 197, 202, 203, 204, 
	197, 197, 197, 213, 197, 239, 197, 207, 
	197, 232, 233, 238, 238, 5, 202, 203, 
	204, 197, 197, 197, 236, 197, 197, 206, 
	207, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 208, 197, 232, 
	233, 234, 238, 5, 202, 203, 204, 197, 
	197, 31, 236, 197, 197, 206, 207, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 208, 197, 230, 197, 271, 
	197, 256, 256, 5, 202, 203, 204, 197, 
	197, 197, 213, 197, 230, 197, 207, 197, 
	230, 197, 197, 197, 197, 197, 197, 202, 
	203, 204, 197, 197, 197, 213, 197, 230, 
	197, 207, 197, 230, 197, 197, 197, 197, 
	272, 197, 202, 203, 204, 197, 197, 197, 
	213, 197, 230, 197, 207, 197, 230, 197, 
	271, 197, 197, 197, 197, 202, 203, 204, 
	197, 197, 197, 213, 197, 230, 197, 207, 
	197, 230, 2, 197, 197, 18, 231, 197, 
	202, 203, 204, 197, 197, 197, 213, 197, 
	230, 197, 207, 197, 223, 224, 229, 229, 
	5, 202, 203, 204, 197, 197, 197, 227, 
	197, 197, 206, 207, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	208, 197, 223, 224, 225, 229, 5, 202, 
	203, 204, 197, 197, 33, 227, 197, 197, 
	206, 207, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 208, 197, 
	221, 197, 273, 197, 256, 256, 5, 202, 
	203, 204, 197, 197, 197, 213, 197, 221, 
	197, 207, 197, 221, 197, 197, 197, 197, 
	197, 197, 202, 203, 204, 197, 197, 197, 
	213, 197, 221, 197, 207, 197, 221, 197, 
	197, 197, 197, 274, 197, 202, 203, 204, 
	197, 197, 197, 213, 197, 221, 197, 207, 
	197, 221, 197, 273, 197, 197, 197, 197, 
	202, 203, 204, 197, 197, 197, 213, 197, 
	221, 197, 207, 197, 221, 2, 197, 197, 
	18, 222, 197, 202, 203, 204, 197, 197, 
	197, 213, 197, 221, 197, 207, 197, 214, 
	215, 220, 220, 5, 202, 203, 204, 197, 
	197, 197, 218, 197, 197, 206, 207, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 208, 197, 214, 215, 216, 
	220, 5, 202, 203, 204, 197, 197, 35, 
	218, 197, 197, 206, 207, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 208, 197, 211, 197, 275, 197, 256, 
	256, 5, 202, 203, 204, 197, 197, 197, 
	213, 197, 211, 197, 207, 197, 211, 197, 
	197, 197, 197, 197, 197, 202, 203, 204, 
	197, 197, 197, 213, 197, 211, 197, 207, 
	197, 211, 197, 197, 197, 197, 276, 197, 
	202, 203, 204, 197, 197, 197, 213, 197, 
	211, 197, 207, 197, 211, 197, 275, 197, 
	197, 197, 197, 202, 203, 204, 197, 197, 
	197, 213, 197, 211, 197, 207, 197, 211, 
	2, 197, 197, 18, 212, 197, 202, 203, 
	204, 197, 197, 197, 213, 197, 211, 197, 
	207, 197, 198, 199, 210, 210, 5, 202, 
	203, 204, 197, 197, 197, 205, 197, 197, 
	206, 207, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 208, 197, 
	198, 199, 200, 210, 5, 202, 203, 204, 
	197, 197, 37, 205, 197, 197, 206, 207, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 208, 197, 278, 279, 
	280, 281, 43, 282, 283, 284, 277, 277, 
	75, 285, 277, 277, 286, 287, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 288, 277, 289, 279, 290, 281, 
	43, 282, 283, 284, 277, 277, 277, 285, 
	277, 277, 286, 287, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	288, 277, 279, 290, 281, 43, 282, 283, 
	284, 277, 277, 277, 285, 277, 277, 286, 
	287, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 288, 277, 291, 
	277, 277, 277, 56, 292, 277, 282, 283, 
	284, 277, 277, 277, 293, 277, 291, 277, 
	287, 277, 294, 295, 296, 297, 43, 282, 
	283, 284, 277, 277, 73, 298, 277, 277, 
	286, 287, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 288, 277, 
	299, 295, 300, 300, 43, 282, 283, 284, 
	277, 277, 277, 298, 277, 277, 286, 287, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 288, 277, 295, 300, 
	300, 43, 282, 283, 284, 277, 277, 277, 
	298, 277, 277, 286, 287, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 288, 277, 301, 277, 277, 277, 56, 
	302, 277, 282, 283, 284, 277, 277, 277, 
	293, 277, 301, 277, 287, 277, 303, 304, 
	305, 306, 43, 282, 283, 284, 277, 277, 
	71, 307, 277, 277, 286, 287, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 288, 277, 308, 304, 309, 309, 
	43, 282, 283, 284, 277, 277, 277, 307, 
	277, 277, 286, 287, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	288, 277, 304, 309, 309, 43, 282, 283, 
	284, 277, 277, 277, 307, 277, 277, 286, 
	287, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 288, 277, 310, 
	277, 277, 277, 56, 311, 277, 282, 283, 
	284, 277, 277, 277, 293, 277, 310, 277, 
	287, 277, 312, 313, 314, 315, 43, 282, 
	283, 284, 277, 277, 69, 316, 277, 277, 
	286, 287, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 288, 277, 
	317, 313, 318, 318, 43, 282, 283, 284, 
	277, 277, 277, 316, 277, 277, 286, 287, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 288, 277, 313, 318, 
	318, 43, 282, 283, 284, 277, 277, 277, 
	316, 277, 277, 286, 287, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 288, 277, 319, 277, 277, 277, 56, 
	320, 277, 282, 283, 284, 277, 277, 277, 
	293, 277, 319, 277, 287, 277, 321, 322, 
	323, 324, 43, 282, 283, 284, 277, 277, 
	67, 325, 277, 277, 286, 287, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 288, 277, 326, 322, 327, 327, 
	43, 282, 283, 284, 277, 277, 277, 325, 
	277, 277, 286, 287, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	288, 277, 322, 327, 327, 43, 282, 283, 
	284, 277, 277, 277, 325, 277, 277, 286, 
	287, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 288, 277, 56, 
	328, 277, 282, 283, 284, 277, 277, 277, 
	293, 277, 277, 277, 287, 277, 282, 283, 
	284, 277, 277, 277, 293, 277, 277, 277, 
	287, 277, 329, 277, 277, 330, 283, 284, 
	277, 283, 284, 277, 283, 331, 277, 283, 
	277, 329, 277, 277, 277, 283, 284, 277, 
	332, 277, 333, 334, 277, 282, 283, 284, 
	277, 277, 41, 277, 277, 277, 277, 287, 
	277, 40, 277, 277, 277, 277, 282, 283, 
	284, 277, 277, 277, 277, 277, 277, 277, 
	287, 277, 282, 283, 284, 277, 277, 277, 
	277, 277, 277, 277, 287, 277, 335, 277, 
	277, 277, 277, 282, 283, 284, 277, 282, 
	283, 284, 277, 332, 277, 277, 277, 277, 
	282, 283, 284, 277, 277, 277, 277, 277, 
	277, 277, 287, 277, 332, 277, 333, 277, 
	277, 282, 283, 284, 277, 277, 41, 277, 
	277, 277, 277, 287, 277, 56, 277, 336, 
	336, 43, 282, 283, 284, 277, 277, 277, 
	293, 277, 277, 277, 287, 277, 337, 65, 
	338, 339, 46, 282, 283, 284, 277, 277, 
	277, 293, 277, 277, 277, 287, 277, 65, 
	338, 339, 46, 282, 283, 284, 277, 277, 
	277, 293, 277, 277, 277, 287, 277, 338, 
	338, 46, 282, 283, 284, 277, 277, 277, 
	293, 277, 277, 277, 287, 277, 340, 62, 
	341, 342, 49, 282, 283, 284, 277, 277, 
	277, 293, 277, 277, 277, 287, 277, 62, 
	341, 342, 49, 282, 283, 284, 277, 277, 
	277, 293, 277, 277, 277, 287, 277, 341, 
	341, 49, 282, 283, 284, 277, 277, 277, 
	293, 277, 277, 277, 287, 277, 343, 59, 
	344, 345, 52, 282, 283, 284, 277, 277, 
	277, 293, 277, 277, 277, 287, 277, 59, 
	344, 345, 52, 282, 283, 284, 277, 277, 
	277, 293, 277, 277, 277, 287, 277, 344, 
	344, 52, 282, 283, 284, 277, 277, 277, 
	293, 277, 277, 277, 287, 277, 346, 56, 
	277, 347, 277, 282, 283, 284, 277, 277, 
	277, 293, 277, 277, 277, 287, 277, 56, 
	277, 347, 277, 282, 283, 284, 277, 277, 
	277, 293, 277, 277, 277, 287, 277, 348, 
	277, 282, 283, 284, 277, 277, 277, 293, 
	277, 277, 277, 287, 277, 56, 277, 277, 
	277, 277, 282, 283, 284, 277, 277, 277, 
	293, 277, 277, 277, 287, 277, 39, 40, 
	277, 277, 56, 328, 277, 282, 283, 284, 
	277, 277, 277, 293, 277, 39, 277, 287, 
	277, 322, 327, 327, 43, 282, 283, 284, 
	277, 277, 277, 325, 277, 277, 277, 287, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 288, 277, 322, 327, 
	327, 43, 282, 283, 284, 277, 277, 277, 
	325, 277, 277, 277, 287, 277, 321, 322, 
	327, 327, 43, 282, 283, 284, 277, 277, 
	277, 325, 277, 277, 286, 287, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 288, 277, 321, 322, 323, 327, 
	43, 282, 283, 284, 277, 277, 67, 325, 
	277, 277, 286, 287, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	288, 277, 319, 277, 349, 277, 336, 336, 
	43, 282, 283, 284, 277, 277, 277, 293, 
	277, 319, 277, 287, 277, 319, 277, 277, 
	277, 277, 277, 277, 282, 283, 284, 277, 
	277, 277, 293, 277, 319, 277, 287, 277, 
	319, 277, 277, 277, 277, 350, 277, 282, 
	283, 284, 277, 277, 277, 293, 277, 319, 
	277, 287, 277, 319, 277, 349, 277, 277, 
	277, 277, 282, 283, 284, 277, 277, 277, 
	293, 277, 319, 277, 287, 277, 319, 40, 
	277, 277, 56, 320, 277, 282, 283, 284, 
	277, 277, 277, 293, 277, 319, 277, 287, 
	277, 312, 313, 318, 318, 43, 282, 283, 
	284, 277, 277, 277, 316, 277, 277, 286, 
	287, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 288, 277, 312, 
	313, 314, 318, 43, 282, 283, 284, 277, 
	277, 69, 316, 277, 277, 286, 287, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 288, 277, 310, 277, 351, 
	277, 336, 336, 43, 282, 283, 284, 277, 
	277, 277, 293, 277, 310, 277, 287, 277, 
	310, 277, 277, 277, 277, 277, 277, 282, 
	283, 284, 277, 277, 277, 293, 277, 310, 
	277, 287, 277, 310, 277, 277, 277, 277, 
	352, 277, 282, 283, 284, 277, 277, 277, 
	293, 277, 310, 277, 287, 277, 310, 277, 
	351, 277, 277, 277, 277, 282, 283, 284, 
	277, 277, 277, 293, 277, 310, 277, 287, 
	277, 310, 40, 277, 277, 56, 311, 277, 
	282, 283, 284, 277, 277, 277, 293, 277, 
	310, 277, 287, 277, 303, 304, 309, 309, 
	43, 282, 283, 284, 277, 277, 277, 307, 
	277, 277, 286, 287, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	288, 277, 303, 304, 305, 309, 43, 282, 
	283, 284, 277, 277, 71, 307, 277, 277, 
	286, 287, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 288, 277, 
	301, 277, 353, 277, 336, 336, 43, 282, 
	283, 284, 277, 277, 277, 293, 277, 301, 
	277, 287, 277, 301, 277, 277, 277, 277, 
	277, 277, 282, 283, 284, 277, 277, 277, 
	293, 277, 301, 277, 287, 277, 301, 277, 
	277, 277, 277, 354, 277, 282, 283, 284, 
	277, 277, 277, 293, 277, 301, 277, 287, 
	277, 301, 277, 353, 277, 277, 277, 277, 
	282, 283, 284, 277, 277, 277, 293, 277, 
	301, 277, 287, 277, 301, 40, 277, 277, 
	56, 302, 277, 282, 283, 284, 277, 277, 
	277, 293, 277, 301, 277, 287, 277, 294, 
	295, 300, 300, 43, 282, 283, 284, 277, 
	277, 277, 298, 277, 277, 286, 287, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 288, 277, 294, 295, 296, 
	300, 43, 282, 283, 284, 277, 277, 73, 
	298, 277, 277, 286, 287, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 288, 277, 291, 277, 355, 277, 336, 
	336, 43, 282, 283, 284, 277, 277, 277, 
	293, 277, 291, 277, 287, 277, 291, 277, 
	277, 277, 277, 277, 277, 282, 283, 284, 
	277, 277, 277, 293, 277, 291, 277, 287, 
	277, 291, 277, 277, 277, 277, 356, 277, 
	282, 283, 284, 277, 277, 277, 293, 277, 
	291, 277, 287, 277, 291, 277, 355, 277, 
	277, 277, 277, 282, 283, 284, 277, 277, 
	277, 293, 277, 291, 277, 287, 277, 74, 
	42, 42, 43, 277, 277, 277, 277, 277, 
	277, 74, 277, 291, 40, 277, 277, 56, 
	292, 277, 282, 283, 284, 277, 277, 277, 
	293, 277, 291, 277, 287, 277, 278, 279, 
	290, 281, 43, 282, 283, 284, 277, 277, 
	277, 285, 277, 277, 286, 287, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 288, 277, 358, 184, 359, 359, 
	81, 187, 188, 189, 357, 357, 357, 191, 
	357, 357, 194, 360, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 184, 359, 359, 81, 187, 188, 
	189, 357, 357, 357, 191, 357, 357, 194, 
	360, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 196, 357, 361, 
	357, 357, 357, 95, 362, 357, 187, 188, 
	189, 357, 357, 357, 363, 357, 361, 357, 
	360, 357, 364, 365, 366, 367, 81, 187, 
	188, 189, 357, 357, 112, 368, 357, 357, 
	194, 360, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 196, 357, 
	369, 365, 370, 370, 81, 187, 188, 189, 
	357, 357, 357, 368, 357, 357, 194, 360, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 196, 357, 365, 370, 
	370, 81, 187, 188, 189, 357, 357, 357, 
	368, 357, 357, 194, 360, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 196, 357, 371, 357, 357, 357, 95, 
	372, 357, 187, 188, 189, 357, 357, 357, 
	363, 357, 371, 357, 360, 357, 373, 374, 
	375, 376, 81, 187, 188, 189, 357, 357, 
	110, 377, 357, 357, 194, 360, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 378, 374, 379, 379, 
	81, 187, 188, 189, 357, 357, 357, 377, 
	357, 357, 194, 360, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 374, 379, 379, 81, 187, 188, 
	189, 357, 357, 357, 377, 357, 357, 194, 
	360, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 196, 357, 380, 
	357, 357, 357, 95, 381, 357, 187, 188, 
	189, 357, 357, 357, 363, 357, 380, 357, 
	360, 357, 382, 383, 384, 385, 81, 187, 
	188, 189, 357, 357, 108, 386, 357, 357, 
	194, 360, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 196, 357, 
	387, 383, 388, 388, 81, 187, 188, 189, 
	357, 357, 357, 386, 357, 357, 194, 360, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 196, 357, 383, 388, 
	388, 81, 187, 188, 189, 357, 357, 357, 
	386, 357, 357, 194, 360, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 196, 357, 389, 357, 357, 357, 95, 
	390, 357, 187, 188, 189, 357, 357, 357, 
	363, 357, 389, 357, 360, 357, 391, 392, 
	393, 394, 81, 187, 188, 189, 357, 357, 
	106, 395, 357, 357, 194, 360, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 396, 392, 397, 397, 
	81, 187, 188, 189, 357, 357, 357, 395, 
	357, 357, 194, 360, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 392, 397, 397, 81, 187, 188, 
	189, 357, 357, 357, 395, 357, 357, 194, 
	360, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 196, 357, 95, 
	398, 357, 187, 188, 189, 357, 357, 357, 
	363, 357, 357, 357, 360, 357, 187, 188, 
	189, 357, 357, 357, 363, 357, 357, 357, 
	360, 357, 399, 357, 357, 400, 188, 189, 
	357, 188, 189, 357, 188, 401, 357, 188, 
	357, 399, 357, 357, 357, 188, 189, 357, 
	402, 357, 403, 404, 357, 187, 188, 189, 
	357, 357, 79, 357, 357, 357, 357, 360, 
	357, 78, 357, 357, 357, 357, 187, 188, 
	189, 357, 357, 357, 357, 357, 357, 357, 
	360, 357, 187, 188, 189, 357, 357, 357, 
	357, 357, 357, 357, 360, 357, 405, 357, 
	357, 357, 357, 187, 188, 189, 357, 187, 
	188, 189, 357, 402, 357, 357, 357, 357, 
	187, 188, 189, 357, 357, 357, 357, 357, 
	357, 357, 360, 357, 402, 357, 403, 357, 
	357, 187, 188, 189, 357, 357, 79, 357, 
	357, 357, 357, 360, 357, 95, 357, 406, 
	406, 81, 187, 188, 189, 357, 357, 357, 
	363, 357, 357, 357, 360, 357, 407, 104, 
	408, 409, 85, 187, 188, 189, 357, 357, 
	357, 363, 357, 357, 357, 360, 357, 104, 
	408, 409, 85, 187, 188, 189, 357, 357, 
	357, 363, 357, 357, 357, 360, 357, 408, 
	408, 85, 187, 188, 189, 357, 357, 357, 
	363, 357, 357, 357, 360, 357, 410, 101, 
	411, 412, 88, 187, 188, 189, 357, 357, 
	357, 363, 357, 357, 357, 360, 357, 101, 
	411, 412, 88, 187, 188, 189, 357, 357, 
	357, 363, 357, 357, 357, 360, 357, 411, 
	411, 88, 187, 188, 189, 357, 357, 357, 
	363, 357, 357, 357, 360, 357, 413, 98, 
	414, 415, 91, 187, 188, 189, 357, 357, 
	357, 363, 357, 357, 357, 360, 357, 98, 
	414, 415, 91, 187, 188, 189, 357, 357, 
	357, 363, 357, 357, 357, 360, 357, 414, 
	414, 91, 187, 188, 189, 357, 357, 357, 
	363, 357, 357, 357, 360, 357, 416, 95, 
	357, 417, 357, 187, 188, 189, 357, 357, 
	357, 363, 357, 357, 357, 360, 357, 95, 
	357, 417, 357, 187, 188, 189, 357, 357, 
	357, 363, 357, 357, 357, 360, 357, 418, 
	357, 187, 188, 189, 357, 357, 357, 363, 
	357, 357, 357, 360, 357, 95, 357, 357, 
	357, 357, 187, 188, 189, 357, 357, 357, 
	363, 357, 357, 357, 360, 357, 77, 78, 
	357, 357, 95, 398, 357, 187, 188, 189, 
	357, 357, 357, 363, 357, 77, 357, 360, 
	357, 392, 397, 397, 81, 187, 188, 189, 
	357, 357, 357, 395, 357, 357, 357, 360, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 196, 357, 392, 397, 
	397, 81, 187, 188, 189, 357, 357, 357, 
	395, 357, 357, 357, 360, 357, 391, 392, 
	397, 397, 81, 187, 188, 189, 357, 357, 
	357, 395, 357, 357, 194, 360, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 391, 392, 393, 397, 
	81, 187, 188, 189, 357, 357, 106, 395, 
	357, 357, 194, 360, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 389, 357, 419, 357, 406, 406, 
	81, 187, 188, 189, 357, 357, 357, 363, 
	357, 389, 357, 360, 357, 389, 357, 357, 
	357, 357, 357, 357, 187, 188, 189, 357, 
	357, 357, 363, 357, 389, 357, 360, 357, 
	389, 357, 357, 357, 357, 420, 357, 187, 
	188, 189, 357, 357, 357, 363, 357, 389, 
	357, 360, 357, 389, 357, 419, 357, 357, 
	357, 357, 187, 188, 189, 357, 357, 357, 
	363, 357, 389, 357, 360, 357, 389, 78, 
	357, 357, 95, 390, 357, 187, 188, 189, 
	357, 357, 357, 363, 357, 389, 357, 360, 
	357, 382, 383, 388, 388, 81, 187, 188, 
	189, 357, 357, 357, 386, 357, 357, 194, 
	360, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 196, 357, 382, 
	383, 384, 388, 81, 187, 188, 189, 357, 
	357, 108, 386, 357, 357, 194, 360, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 196, 357, 380, 357, 421, 
	357, 406, 406, 81, 187, 188, 189, 357, 
	357, 357, 363, 357, 380, 357, 360, 357, 
	380, 357, 357, 357, 357, 357, 357, 187, 
	188, 189, 357, 357, 357, 363, 357, 380, 
	357, 360, 357, 380, 357, 357, 357, 357, 
	422, 357, 187, 188, 189, 357, 357, 357, 
	363, 357, 380, 357, 360, 357, 380, 357, 
	421, 357, 357, 357, 357, 187, 188, 189, 
	357, 357, 357, 363, 357, 380, 357, 360, 
	357, 380, 78, 357, 357, 95, 381, 357, 
	187, 188, 189, 357, 357, 357, 363, 357, 
	380, 357, 360, 357, 373, 374, 379, 379, 
	81, 187, 188, 189, 357, 357, 357, 377, 
	357, 357, 194, 360, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 373, 374, 375, 379, 81, 187, 
	188, 189, 357, 357, 110, 377, 357, 357, 
	194, 360, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 196, 357, 
	371, 357, 423, 357, 406, 406, 81, 187, 
	188, 189, 357, 357, 357, 363, 357, 371, 
	357, 360, 357, 371, 357, 357, 357, 357, 
	357, 357, 187, 188, 189, 357, 357, 357, 
	363, 357, 371, 357, 360, 357, 371, 357, 
	357, 357, 357, 424, 357, 187, 188, 189, 
	357, 357, 357, 363, 357, 371, 357, 360, 
	357, 371, 357, 423, 357, 357, 357, 357, 
	187, 188, 189, 357, 357, 357, 363, 357, 
	371, 357, 360, 357, 371, 78, 357, 357, 
	95, 372, 357, 187, 188, 189, 357, 357, 
	357, 363, 357, 371, 357, 360, 357, 364, 
	365, 370, 370, 81, 187, 188, 189, 357, 
	357, 357, 368, 357, 357, 194, 360, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 357, 196, 357, 364, 365, 366, 
	370, 81, 187, 188, 189, 357, 357, 112, 
	368, 357, 357, 194, 360, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 196, 357, 361, 357, 425, 357, 406, 
	406, 81, 187, 188, 189, 357, 357, 357, 
	363, 357, 361, 357, 360, 357, 361, 357, 
	357, 357, 357, 357, 357, 187, 188, 189, 
	357, 357, 357, 363, 357, 361, 357, 360, 
	357, 361, 357, 357, 357, 357, 426, 357, 
	187, 188, 189, 357, 357, 357, 363, 357, 
	361, 357, 360, 357, 361, 357, 425, 357, 
	357, 357, 357, 187, 188, 189, 357, 357, 
	357, 363, 357, 361, 357, 360, 357, 361, 
	78, 357, 357, 95, 362, 357, 187, 188, 
	189, 357, 357, 357, 363, 357, 361, 357, 
	360, 357, 113, 80, 80, 81, 427, 427, 
	427, 427, 427, 152, 113, 427, 183, 184, 
	359, 359, 81, 187, 188, 189, 357, 357, 
	357, 191, 357, 357, 194, 360, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	357, 357, 196, 357, 113, 80, 80, 81, 
	427, 427, 427, 427, 427, 427, 113, 427, 
	429, 430, 431, 432, 119, 433, 434, 435, 
	428, 428, 151, 436, 428, 428, 437, 438, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 439, 428, 440, 430, 
	432, 432, 119, 433, 434, 435, 428, 428, 
	428, 436, 428, 428, 437, 438, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 439, 428, 430, 432, 432, 119, 
	433, 434, 435, 428, 428, 428, 436, 428, 
	428, 437, 438, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 439, 
	428, 441, 428, 428, 428, 132, 442, 428, 
	433, 434, 435, 428, 428, 428, 443, 428, 
	441, 428, 438, 428, 444, 445, 446, 447, 
	119, 433, 434, 435, 428, 428, 149, 448, 
	428, 428, 437, 438, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	439, 428, 449, 445, 450, 450, 119, 433, 
	434, 435, 428, 428, 428, 448, 428, 428, 
	437, 438, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 439, 428, 
	445, 450, 450, 119, 433, 434, 435, 428, 
	428, 428, 448, 428, 428, 437, 438, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 439, 428, 451, 428, 428, 
	428, 132, 452, 428, 433, 434, 435, 428, 
	428, 428, 443, 428, 451, 428, 438, 428, 
	453, 454, 455, 456, 119, 433, 434, 435, 
	428, 428, 147, 457, 428, 428, 437, 438, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 439, 428, 458, 454, 
	459, 459, 119, 433, 434, 435, 428, 428, 
	428, 457, 428, 428, 437, 438, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 439, 428, 454, 459, 459, 119, 
	433, 434, 435, 428, 428, 428, 457, 428, 
	428, 437, 438, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 439, 
	428, 460, 428, 428, 428, 132, 461, 428, 
	433, 434, 435, 428, 428, 428, 443, 428, 
	460, 428, 438, 428, 462, 463, 464, 465, 
	119, 433, 434, 435, 428, 428, 145, 466, 
	428, 428, 437, 438, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	439, 428, 467, 463, 468, 468, 119, 433, 
	434, 435, 428, 428, 428, 466, 428, 428, 
	437, 438, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 439, 428, 
	463, 468, 468, 119, 433, 434, 435, 428, 
	428, 428, 466, 428, 428, 437, 438, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 439, 428, 469, 428, 428, 
	428, 132, 470, 428, 433, 434, 435, 428, 
	428, 428, 443, 428, 469, 428, 438, 428, 
	471, 472, 473, 474, 119, 433, 434, 435, 
	428, 428, 143, 475, 428, 428, 437, 438, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 439, 428, 476, 472, 
	477, 477, 119, 433, 434, 435, 428, 428, 
	428, 475, 428, 428, 437, 438, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 439, 428, 472, 477, 477, 119, 
	433, 434, 435, 428, 428, 428, 475, 428, 
	428, 437, 438, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 439, 
	428, 132, 478, 428, 433, 434, 435, 428, 
	428, 428, 443, 428, 428, 428, 438, 428, 
	433, 434, 435, 428, 428, 428, 443, 428, 
	428, 428, 438, 428, 479, 428, 428, 480, 
	434, 435, 428, 434, 435, 428, 434, 481, 
	428, 434, 428, 479, 428, 428, 428, 434, 
	435, 428, 482, 428, 483, 484, 428, 433, 
	434, 435, 428, 428, 117, 428, 428, 428, 
	428, 438, 428, 116, 428, 428, 428, 428, 
	433, 434, 435, 428, 428, 428, 428, 428, 
	428, 428, 438, 428, 433, 434, 435, 428, 
	428, 428, 428, 428, 428, 428, 438, 428, 
	485, 428, 428, 428, 428, 433, 434, 435, 
	428, 433, 434, 435, 428, 482, 428, 428, 
	428, 428, 433, 434, 435, 428, 428, 428, 
	428, 428, 428, 428, 438, 428, 482, 428, 
	483, 428, 428, 433, 434, 435, 428, 428, 
	117, 428, 428, 428, 428, 438, 428, 132, 
	428, 486, 486, 119, 433, 434, 435, 428, 
	428, 428, 443, 428, 428, 428, 438, 428, 
	487, 141, 488, 489, 122, 433, 434, 435, 
	428, 428, 428, 443, 428, 428, 428, 438, 
	428, 141, 488, 489, 122, 433, 434, 435, 
	428, 428, 428, 443, 428, 428, 428, 438, 
	428, 488, 488, 122, 433, 434, 435, 428, 
	428, 428, 443, 428, 428, 428, 438, 428, 
	490, 138, 491, 492, 125, 433, 434, 435, 
	428, 428, 428, 443, 428, 428, 428, 438, 
	428, 138, 491, 492, 125, 433, 434, 435, 
	428, 428, 428, 443, 428, 428, 428, 438, 
	428, 491, 491, 125, 433, 434, 435, 428, 
	428, 428, 443, 428, 428, 428, 438, 428, 
	493, 135, 494, 495, 128, 433, 434, 435, 
	428, 428, 428, 443, 428, 428, 428, 438, 
	428, 135, 494, 495, 128, 433, 434, 435, 
	428, 428, 428, 443, 428, 428, 428, 438, 
	428, 494, 494, 128, 433, 434, 435, 428, 
	428, 428, 443, 428, 428, 428, 438, 428, 
	496, 132, 428, 497, 428, 433, 434, 435, 
	428, 428, 428, 443, 428, 428, 428, 438, 
	428, 132, 428, 497, 428, 433, 434, 435, 
	428, 428, 428, 443, 428, 428, 428, 438, 
	428, 498, 428, 433, 434, 435, 428, 428, 
	428, 443, 428, 428, 428, 438, 428, 132, 
	428, 428, 428, 428, 433, 434, 435, 428, 
	428, 428, 443, 428, 428, 428, 438, 428, 
	115, 116, 428, 428, 132, 478, 428, 433, 
	434, 435, 428, 428, 428, 443, 428, 115, 
	428, 438, 428, 472, 477, 477, 119, 433, 
	434, 435, 428, 428, 428, 475, 428, 428, 
	428, 438, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 439, 428, 
	472, 477, 477, 119, 433, 434, 435, 428, 
	428, 428, 475, 428, 428, 428, 438, 428, 
	471, 472, 477, 477, 119, 433, 434, 435, 
	428, 428, 428, 475, 428, 428, 437, 438, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 439, 428, 471, 472, 
	473, 477, 119, 433, 434, 435, 428, 428, 
	143, 475, 428, 428, 437, 438, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 439, 428, 469, 428, 499, 428, 
	486, 486, 119, 433, 434, 435, 428, 428, 
	428, 443, 428, 469, 428, 438, 428, 469, 
	428, 428, 428, 428, 428, 428, 433, 434, 
	435, 428, 428, 428, 443, 428, 469, 428, 
	438, 428, 469, 428, 428, 428, 428, 500, 
	428, 433, 434, 435, 428, 428, 428, 443, 
	428, 469, 428, 438, 428, 469, 428, 499, 
	428, 428, 428, 428, 433, 434, 435, 428, 
	428, 428, 443, 428, 469, 428, 438, 428, 
	469, 116, 428, 428, 132, 470, 428, 433, 
	434, 435, 428, 428, 428, 443, 428, 469, 
	428, 438, 428, 462, 463, 468, 468, 119, 
	433, 434, 435, 428, 428, 428, 466, 428, 
	428, 437, 438, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 439, 
	428, 462, 463, 464, 468, 119, 433, 434, 
	435, 428, 428, 145, 466, 428, 428, 437, 
	438, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 439, 428, 460, 
	428, 501, 428, 486, 486, 119, 433, 434, 
	435, 428, 428, 428, 443, 428, 460, 428, 
	438, 428, 460, 428, 428, 428, 428, 428, 
	428, 433, 434, 435, 428, 428, 428, 443, 
	428, 460, 428, 438, 428, 460, 428, 428, 
	428, 428, 502, 428, 433, 434, 435, 428, 
	428, 428, 443, 428, 460, 428, 438, 428, 
	460, 428, 501, 428, 428, 428, 428, 433, 
	434, 435, 428, 428, 428, 443, 428, 460, 
	428, 438, 428, 460, 116, 428, 428, 132, 
	461, 428, 433, 434, 435, 428, 428, 428, 
	443, 428, 460, 428, 438, 428, 453, 454, 
	459, 459, 119, 433, 434, 435, 428, 428, 
	428, 457, 428, 428, 437, 438, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 439, 428, 453, 454, 455, 459, 
	119, 433, 434, 435, 428, 428, 147, 457, 
	428, 428, 437, 438, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	439, 428, 451, 428, 503, 428, 486, 486, 
	119, 433, 434, 435, 428, 428, 428, 443, 
	428, 451, 428, 438, 428, 451, 428, 428, 
	428, 428, 428, 428, 433, 434, 435, 428, 
	428, 428, 443, 428, 451, 428, 438, 428, 
	451, 428, 428, 428, 428, 504, 428, 433, 
	434, 435, 428, 428, 428, 443, 428, 451, 
	428, 438, 428, 451, 428, 503, 428, 428, 
	428, 428, 433, 434, 435, 428, 428, 428, 
	443, 428, 451, 428, 438, 428, 451, 116, 
	428, 428, 132, 452, 428, 433, 434, 435, 
	428, 428, 428, 443, 428, 451, 428, 438, 
	428, 444, 445, 450, 450, 119, 433, 434, 
	435, 428, 428, 428, 448, 428, 428, 437, 
	438, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 439, 428, 444, 
	445, 446, 450, 119, 433, 434, 435, 428, 
	428, 149, 448, 428, 428, 437, 438, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	428, 428, 428, 439, 428, 441, 428, 505, 
	428, 486, 486, 119, 433, 434, 435, 428, 
	428, 428, 443, 428, 441, 428, 438, 428, 
	441, 428, 428, 428, 428, 428, 428, 433, 
	434, 435, 428, 428, 428, 443, 428, 441, 
	428, 438, 428, 441, 428, 428, 428, 428, 
	506, 428, 433, 434, 435, 428, 428, 428, 
	443, 428, 441, 428, 438, 428, 441, 428, 
	505, 428, 428, 428, 428, 433, 434, 435, 
	428, 428, 428, 443, 428, 441, 428, 438, 
	428, 441, 116, 428, 428, 132, 442, 428, 
	433, 434, 435, 428, 428, 428, 443, 428, 
	441, 428, 438, 428, 429, 430, 432, 432, 
	119, 433, 434, 435, 428, 428, 428, 436, 
	428, 428, 437, 438, 428, 428, 428, 428, 
	428, 428, 428, 428, 428, 428, 428, 428, 
	439, 428, 181, 182, 183, 184, 507, 359, 
	81, 187, 188, 189, 190, 190, 152, 191, 
	357, 181, 194, 360, 357, 357, 357, 357, 
	357, 357, 357, 357, 357, 357, 357, 357, 
	196, 357, 198, 508, 200, 201, 5, 202, 
	203, 204, 197, 197, 37, 205, 197, 197, 
	206, 207, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 208, 197, 
	211, 182, 183, 184, 509, 510, 81, 511, 
	203, 512, 190, 190, 152, 513, 197, 211, 
	194, 514, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 196, 197, 
	113, 80, 80, 81, 202, 203, 204, 197, 
	197, 152, 515, 197, 197, 197, 207, 197, 
	516, 2, 357, 357, 357, 426, 357, 187, 
	188, 189, 357, 357, 357, 363, 357, 516, 
	357, 360, 357, 517, 365, 518, 519, 81, 
	511, 203, 512, 197, 197, 153, 368, 197, 
	197, 194, 514, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 196, 
	197, 520, 365, 370, 370, 81, 511, 203, 
	512, 197, 197, 197, 368, 197, 197, 194, 
	514, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 197, 197, 196, 197, 365, 
	370, 370, 81, 511, 203, 512, 197, 197, 
	197, 368, 197, 197, 194, 514, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 196, 197, 521, 197, 197, 522, 
	203, 512, 197, 203, 512, 197, 203, 523, 
	197, 203, 197, 521, 197, 197, 197, 203, 
	512, 197, 524, 197, 197, 197, 197, 511, 
	203, 512, 197, 511, 203, 512, 197, 517, 
	365, 370, 370, 81, 511, 203, 512, 197, 
	197, 197, 368, 197, 197, 194, 514, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 197, 197, 196, 197, 517, 365, 518, 
	370, 81, 511, 203, 512, 197, 197, 153, 
	368, 197, 197, 194, 514, 197, 197, 197, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 196, 197, 211, 197, 275, 113, 525, 
	525, 155, 202, 203, 204, 197, 197, 197, 
	515, 197, 211, 197, 207, 197, 526, 179, 
	527, 528, 157, 511, 203, 512, 197, 197, 
	197, 529, 197, 197, 197, 514, 197, 179, 
	527, 528, 157, 511, 203, 512, 197, 197, 
	197, 529, 197, 197, 197, 514, 197, 527, 
	527, 157, 511, 203, 512, 197, 197, 197, 
	529, 197, 197, 197, 514, 197, 530, 176, 
	531, 532, 160, 511, 203, 512, 197, 197, 
	197, 529, 197, 197, 197, 514, 197, 176, 
	531, 532, 160, 511, 203, 512, 197, 197, 
	197, 529, 197, 197, 197, 514, 197, 531, 
	531, 160, 511, 203, 512, 197, 197, 197, 
	529, 197, 197, 197, 514, 197, 533, 173, 
	534, 535, 163, 511, 203, 512, 197, 197, 
	197, 529, 197, 197, 197, 514, 197, 173, 
	534, 535, 163, 511, 203, 512, 197, 197, 
	197, 529, 197, 197, 197, 514, 197, 534, 
	534, 163, 511, 203, 512, 197, 197, 197, 
	529, 197, 197, 197, 514, 197, 536, 170, 
	197, 537, 197, 511, 203, 512, 197, 197, 
	197, 529, 197, 197, 197, 514, 197, 170, 
	197, 537, 197, 511, 203, 512, 197, 197, 
	197, 529, 197, 197, 197, 514, 197, 511, 
	203, 512, 197, 197, 197, 529, 197, 197, 
	197, 514, 197, 538, 197, 539, 540, 197, 
	511, 203, 512, 197, 197, 167, 197, 197, 
	197, 197, 514, 197, 166, 197, 197, 197, 
	197, 511, 203, 512, 197, 197, 197, 197, 
	197, 197, 197, 514, 197, 511, 203, 512, 
	197, 197, 197, 197, 197, 197, 197, 514, 
	197, 538, 197, 197, 197, 197, 511, 203, 
	512, 197, 197, 197, 197, 197, 197, 197, 
	514, 197, 538, 197, 539, 197, 197, 511, 
	203, 512, 197, 197, 167, 197, 197, 197, 
	197, 514, 197, 516, 166, 357, 357, 95, 
	362, 357, 187, 188, 189, 357, 357, 357, 
	363, 357, 516, 357, 360, 357, 542, 541, 
	541, 541, 541, 543, 544, 545, 541, 543, 
	544, 545, 541, 546, 541, 541, 547, 544, 
	545, 541, 544, 545, 541, 544, 548, 541, 
	544, 541, 546, 541, 541, 541, 544, 545, 
	541, 0
};

static const short _indic_syllable_machine_trans_targs[] = {
	170, 197, 199, 202, 3, 205, 4, 6, 
	208, 7, 9, 211, 10, 12, 214, 13, 
	15, 16, 191, 18, 19, 213, 21, 22, 
	210, 24, 25, 207, 216, 221, 225, 228, 
	232, 235, 239, 242, 246, 249, 170, 277, 
	279, 282, 39, 285, 40, 42, 288, 43, 
	45, 291, 46, 48, 294, 49, 51, 52, 
	271, 54, 55, 293, 57, 58, 290, 60, 
	61, 287, 296, 301, 305, 308, 312, 315, 
	319, 322, 326, 330, 170, 356, 358, 361, 
	75, 364, 170, 76, 78, 367, 79, 81, 
	370, 82, 84, 373, 85, 87, 88, 350, 
	90, 91, 372, 93, 94, 369, 96, 97, 
	366, 375, 380, 384, 387, 391, 394, 398, 
	401, 405, 170, 437, 439, 442, 110, 445, 
	111, 113, 448, 114, 116, 451, 117, 119, 
	454, 120, 122, 123, 431, 125, 126, 453, 
	128, 129, 450, 131, 132, 447, 456, 461, 
	465, 468, 472, 475, 479, 482, 486, 489, 
	409, 505, 146, 508, 148, 511, 149, 151, 
	514, 152, 154, 517, 155, 520, 522, 523, 
	159, 160, 519, 162, 163, 516, 165, 166, 
	513, 168, 169, 510, 170, 171, 251, 331, 
	333, 408, 410, 351, 170, 353, 411, 407, 
	490, 491, 378, 526, 379, 170, 172, 174, 
	35, 250, 192, 170, 194, 248, 219, 200, 
	220, 173, 34, 175, 244, 0, 176, 178, 
	33, 243, 241, 177, 32, 179, 237, 180, 
	182, 31, 236, 234, 181, 30, 183, 230, 
	184, 186, 29, 229, 227, 185, 28, 187, 
	223, 188, 190, 27, 222, 218, 189, 26, 
	204, 193, 196, 195, 198, 1, 203, 201, 
	2, 206, 5, 23, 209, 8, 20, 212, 
	11, 17, 215, 14, 217, 224, 226, 231, 
	233, 238, 240, 245, 247, 170, 252, 254, 
	71, 328, 272, 170, 274, 329, 299, 280, 
	300, 253, 70, 255, 324, 36, 256, 258, 
	69, 323, 321, 257, 68, 259, 317, 260, 
	262, 67, 316, 314, 261, 66, 263, 310, 
	264, 266, 65, 309, 307, 265, 64, 267, 
	303, 268, 270, 63, 302, 298, 269, 62, 
	284, 273, 276, 275, 278, 37, 283, 281, 
	38, 286, 41, 59, 289, 44, 56, 292, 
	47, 53, 295, 50, 297, 304, 306, 311, 
	313, 318, 320, 325, 327, 170, 332, 106, 
	359, 334, 403, 72, 335, 337, 105, 402, 
	400, 336, 104, 338, 396, 339, 341, 103, 
	395, 393, 340, 102, 342, 389, 343, 345, 
	101, 388, 386, 344, 100, 346, 382, 347, 
	349, 99, 381, 377, 348, 98, 363, 352, 
	355, 354, 357, 73, 362, 360, 74, 365, 
	77, 95, 368, 80, 92, 371, 83, 89, 
	374, 86, 376, 383, 385, 390, 392, 397, 
	399, 404, 406, 170, 170, 412, 414, 142, 
	141, 432, 170, 434, 488, 459, 440, 460, 
	413, 415, 484, 107, 416, 418, 140, 483, 
	481, 417, 139, 419, 477, 420, 422, 138, 
	476, 474, 421, 137, 423, 470, 424, 426, 
	136, 469, 467, 425, 135, 427, 463, 428, 
	430, 134, 462, 458, 429, 133, 444, 433, 
	436, 435, 438, 108, 443, 441, 109, 446, 
	112, 130, 449, 115, 127, 452, 118, 124, 
	455, 121, 457, 464, 466, 471, 473, 478, 
	480, 485, 487, 143, 492, 493, 507, 498, 
	500, 525, 503, 494, 495, 496, 144, 506, 
	497, 499, 502, 501, 504, 145, 509, 147, 
	167, 156, 512, 150, 164, 515, 153, 161, 
	518, 158, 521, 157, 524, 170, 527, 528, 
	170, 530, 529, 532, 531
};

static const char _indic_syllable_machine_trans_actions[] = {
	1, 2, 0, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 0, 
	2, 0, 0, 2, 0, 0, 2, 0, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 4, 2, 0, 0, 
	0, 2, 5, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 2, 6, 2, 6, 2, 6, 2, 
	6, 2, 7, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	6, 8, 0, 2, 0, 2, 0, 0, 
	2, 0, 0, 2, 0, 2, 0, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 2, 11, 2, 2, 6, 
	2, 12, 12, 0, 13, 0, 2, 2, 
	6, 2, 6, 0, 6, 14, 2, 2, 
	0, 2, 0, 15, 0, 2, 2, 0, 
	2, 2, 0, 2, 2, 0, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 2, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 2, 0, 
	2, 0, 0, 0, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 16, 2, 2, 
	0, 2, 0, 17, 0, 2, 2, 0, 
	2, 2, 0, 2, 2, 0, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 2, 
	2, 2, 0, 2, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 2, 0, 
	2, 0, 0, 0, 0, 0, 2, 0, 
	0, 2, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 18, 6, 0, 
	0, 6, 6, 0, 6, 2, 0, 6, 
	2, 6, 0, 6, 6, 6, 2, 0, 
	6, 2, 6, 0, 6, 6, 6, 2, 
	0, 6, 2, 6, 0, 6, 6, 6, 
	2, 0, 6, 2, 6, 0, 6, 0, 
	0, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 19, 20, 2, 2, 0, 
	0, 0, 21, 0, 2, 2, 0, 2, 
	2, 2, 2, 0, 2, 2, 0, 2, 
	2, 2, 0, 2, 2, 2, 2, 0, 
	2, 2, 2, 0, 2, 2, 2, 2, 
	0, 2, 2, 2, 0, 2, 2, 2, 
	2, 0, 2, 2, 2, 0, 2, 0, 
	0, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 0, 0, 8, 2, 0, 
	0, 2, 0, 2, 8, 8, 0, 8, 
	8, 0, 0, 0, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 2, 0, 0, 
	2, 0, 0, 0, 2, 22, 0, 0, 
	23, 0, 0, 0, 0
};

static const char _indic_syllable_machine_to_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 9, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const char _indic_syllable_machine_from_state_actions[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 10, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0
};

static const short _indic_syllable_machine_eof_trans[] = {
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	77, 77, 77, 83, 83, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 77, 77, 77, 77, 
	83, 77, 77, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 115, 
	115, 115, 115, 115, 115, 115, 115, 77, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 0, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	358, 358, 358, 358, 358, 358, 358, 358, 
	428, 358, 428, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 358, 198, 198, 198, 358, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 198, 198, 198, 
	198, 198, 198, 198, 198, 358, 542, 542, 
	542, 542, 542, 542, 542
};

static const int indic_syllable_machine_start = 170;
static const int indic_syllable_machine_first_final = 170;
static const int indic_syllable_machine_error = -1;

static const int indic_syllable_machine_en_main = 170;


#line 36 "hb-ot-shape-complex-indic-machine.rl"



#line 98 "hb-ot-shape-complex-indic-machine.rl"


#define found_syllable(syllable_type) \
  HB_STMT_START { \
    if (0) fprintf (stderr, "syllable %d..%d %s\n", last, p+1, #syllable_type); \
    for (unsigned int i = last; i < p+1; i++) \
      info[i].syllable() = (syllable_serial << 4) | syllable_type; \
    last = p+1; \
    syllable_serial++; \
    if (unlikely (syllable_serial == 16)) syllable_serial = 1; \
  } HB_STMT_END

static void
find_syllables (hb_buffer_t *buffer)
{
  unsigned int p, pe, eof, ts HB_UNUSED, te HB_UNUSED, act HB_UNUSED;
  int cs;
  hb_glyph_info_t *info = buffer->info;
  
#line 1646 "hb-ot-shape-complex-indic-machine.hh"
	{
	cs = indic_syllable_machine_start;
	ts = 0;
	te = 0;
	act = 0;
	}

#line 119 "hb-ot-shape-complex-indic-machine.rl"


  p = 0;
  pe = eof = buffer->len;

  unsigned int last = 0;
  unsigned int syllable_serial = 1;
  
#line 1663 "hb-ot-shape-complex-indic-machine.hh"
	{
	int _slen;
	int _trans;
	const unsigned char *_keys;
	const short *_inds;
	if ( p == pe )
		goto _test_eof;
_resume:
	switch ( _indic_syllable_machine_from_state_actions[cs] ) {
	case 10:
#line 1 "NONE"
	{ts = p;}
	break;
#line 1677 "hb-ot-shape-complex-indic-machine.hh"
	}

	_keys = _indic_syllable_machine_trans_keys + (cs<<1);
	_inds = _indic_syllable_machine_indicies + _indic_syllable_machine_index_offsets[cs];

	_slen = _indic_syllable_machine_key_spans[cs];
	_trans = _inds[ _slen > 0 && _keys[0] <=( info[p].indic_category()) &&
		( info[p].indic_category()) <= _keys[1] ?
		( info[p].indic_category()) - _keys[0] : _slen ];

_eof_trans:
	cs = _indic_syllable_machine_trans_targs[_trans];

	if ( _indic_syllable_machine_trans_actions[_trans] == 0 )
		goto _again;

	switch ( _indic_syllable_machine_trans_actions[_trans] ) {
	case 2:
#line 1 "NONE"
	{te = p+1;}
	break;
	case 15:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (consonant_syllable); }}
	break;
	case 17:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (vowel_syllable); }}
	break;
	case 21:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (standalone_cluster); }}
	break;
	case 23:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (avagraha_cluster); }}
	break;
	case 13:
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (broken_cluster); }}
	break;
	case 11:
#line 94 "hb-ot-shape-complex-indic-machine.rl"
	{te = p+1;{ found_syllable (non_indic_cluster); }}
	break;
	case 14:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (consonant_syllable); }}
	break;
	case 16:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (vowel_syllable); }}
	break;
	case 20:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (standalone_cluster); }}
	break;
	case 22:
#line 92 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (avagraha_cluster); }}
	break;
	case 18:
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (broken_cluster); }}
	break;
	case 19:
#line 94 "hb-ot-shape-complex-indic-machine.rl"
	{te = p;p--;{ found_syllable (non_indic_cluster); }}
	break;
	case 1:
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (consonant_syllable); }}
	break;
	case 3:
#line 90 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (vowel_syllable); }}
	break;
	case 7:
#line 91 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (standalone_cluster); }}
	break;
	case 4:
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{{p = ((te))-1;}{ found_syllable (broken_cluster); }}
	break;
	case 5:
#line 1 "NONE"
	{	switch( act ) {
	case 1:
	{{p = ((te))-1;} found_syllable (consonant_syllable); }
	break;
	case 5:
	{{p = ((te))-1;} found_syllable (broken_cluster); }
	break;
	case 6:
	{{p = ((te))-1;} found_syllable (non_indic_cluster); }
	break;
	}
	}
	break;
	case 8:
#line 1 "NONE"
	{te = p+1;}
#line 89 "hb-ot-shape-complex-indic-machine.rl"
	{act = 1;}
	break;
	case 6:
#line 1 "NONE"
	{te = p+1;}
#line 93 "hb-ot-shape-complex-indic-machine.rl"
	{act = 5;}
	break;
	case 12:
#line 1 "NONE"
	{te = p+1;}
#line 94 "hb-ot-shape-complex-indic-machine.rl"
	{act = 6;}
	break;
#line 1796 "hb-ot-shape-complex-indic-machine.hh"
	}

_again:
	switch ( _indic_syllable_machine_to_state_actions[cs] ) {
	case 9:
#line 1 "NONE"
	{ts = 0;}
	break;
#line 1805 "hb-ot-shape-complex-indic-machine.hh"
	}

	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	if ( _indic_syllable_machine_eof_trans[cs] > 0 ) {
		_trans = _indic_syllable_machine_eof_trans[cs] - 1;
		goto _eof_trans;
	}
	}

	}

#line 128 "hb-ot-shape-complex-indic-machine.rl"

}

#endif /* HB_OT_SHAPE_COMPLEX_INDIC_MACHINE_HH */
