/***************************************************************************
                          qgridview.h  -  QGrid
                             -------------------
    begin                : Fri Jan 12 2001
    copyright            : (C) 2001 by Johan Maes - ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef QGRIDVIEW_H
#define QGRIDVIEW_H

#include <qwidget.h>
#include "central.h"
#include <qpixmap.h>

/**
  *@author Johan Maes - ON1MH
  */

class QgridView : public central  {
   Q_OBJECT
public: 
	QgridView(QWidget *parent=0, const char *name=0);
	~QgridView();
	void saveConfiguration();
public slots:
	void clear();
	void calculateToLL();
	void calculateFromLL();
private:
	int degrees;
	QPixmap compassPix, arrowPix,comboPix;
	void strup(char *st);
	void convertToDMS(float x, int &d,int &m, int &s);
	float convertFromDMS(int d,int m, int s);
	void setInt(QLineEdit *ql,int x);
	void calcLatLong(char *st,float &lat,float &lon);
	void calcLocator(char *st,float n,float e);
	float calcDistance(float latHome,float longHome,float latRemote,float longRemote,float &be);
	bool validateLocator(const char *st);
	void drawCompass();
};

#endif
