#ifndef VISUAL_VCACHE_H
#define VISUAL_VCACHE_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "platform.h"

namespace visual {

class Cache 
{
 public:
	typedef lock<mutex> read_lock;
	typedef counted_lock<mutex> write_lock;
	mutex mtx;

	Cache();
	Cache( const Cache& other);
	virtual ~Cache();

	void updateCache();
	// Called to ensure that the cache is up to date.
	// The caller should hold a read_lock or write_lock first!

	int lastChange();
	// returns a number that increases when write_lock is taken.

 protected:
	virtual void refreshCache() = 0;
	// Called by updateCache() when the cache needs to be refreshed.
	// Returns true if the object should remain in its container, and false
	//   otherwise.

	int lastRefresh; // lastChange() when refreshCache() was last called
};

} // !namespace visual

#endif // !VISUAL_VCACHE_H
