# Copyright (c) 2000 Phil Thompson <phil@river-bank.demon.co.uk>


from qt import QCanvasView, QWhatsThis, QWidget

from Icons import IconFilePython


class SourceViewer(QCanvasView):
    """SourceViewer(self,scn,parent=None)

    A class used to display a Python source file that is broken down into
    separate, colour coded, tokens.  parent is the optional QObject parent.
    scn is the scanned file to view.

    """
    def __init__(self,scn,parent=None):
        QCanvasView.__init__(self,scn,parent)

        # Make sure tabbing through a QWorkspace works.
        self.setFocusPolicy(QWidget.StrongFocus)

        self.setCaption(scn.getFileName())
        self.setIcon(IconFilePython)

        QWhatsThis.add(self,
"""<b>A Source Viewer Window</b>"""
"""<p>This window is used to display a Python source file.  You can open as"""
""" many of these as you like. The name of the file is displayed in the"""
""" window's titlebar.</p>"""
"""<p>Python keywords, names, strings and comments are all highlighted in"""
""" different colors.</p>"""
"""<p>If the program is currently stopped then the next Python statement"""
""" that will be executed is highlighted.</p>"""
"""<p>The column on the left is used to show if a breakpoint has been set at"""
""" that line. To set a breakpoint, just click in the column at the line you"""
""" want. Click again to clear the breakpoint. You can set and clear"""
""" breakpoints at any time, even while the program is running.</p>"""
                      )

        # Set the viewer size if it is too big for the parent.
        if parent is not None:
            req = scn.size()
            bnd = req.boundedTo(parent.size())

            if bnd.width() < req.width() or bnd.height() < req.height():
                self.resize(bnd)

        self.scn = scn

    def getFileName(self):
        """
        Public method to return the name of the file being displayed.
        """
        return self.scn.getFileName()

    def highlightVisible(self):
        """
        Public method to make sure that the highlight bar for the file being
        displayed is visible.
        """
        y = self.canvas().getHighlightPosition()
        self.ensureVisible(0,y)
        self.show()

    def contentsMousePressEvent(self,ev):
        """
        Re-implement to catch mouse clicks.
        """
        # Pass to the underlying canvas.
        self.canvas().mouseClick(ev.x(),ev.y())
