# This file is part of Python FAM.
# Copyright (C) 2005 Martin v. Loewis
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
#

from distutils.core import setup, Extension

ext_modules = [
    Extension('_fam',
              sources = ['_fam.c'],
              libraries = ["fam"])
    ]

setup(name = "python-fam",
      version = "1.1.1",
      description = "Python access to the File Alteration Monitor",
      author = "Robert Sander",
      author_email = "gurubert@users.sf.net",
      url = "http://python-fam.sourceforge.net/",
      long_description = "Python FAM is the interface to the File Alteration Monitor for Python.",
      ext_modules = ext_modules)

