/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "BoxWithLines2DSubVolPy.h"
#include "BoxWithLines2DSubVol.h"

using namespace boost::python;

    void exportBoxWithLines2DSubVol()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<BoxWithLines2DSubVol, bases<BoxWithLines2D> >(
        "BoxWithLines2DSubVol",
        "A class defining a rectangular sub-volume in 2D bounded by lines.",
        init<>()
      )
      .def(init<const BoxWithLines2DSubVol &>())
      .def(
        init<Vector3,Vector3,double,double>(
          ( arg("minPoint"), arg("maxPoint"), arg("svdim_x"), arg("svdim_y") ),
          "Constructs a box with the specified corner points.\n"
          "@type minPoint: L{Vector3}\n"
          "@kwarg minPoint: Coordinate of bottom left corner of the box\n"
          "@type maxPoint: L{Vector3}\n"
          "@kwarg maxPoint: Coordinate of upper right corner of the box\n"
          "@type svdim_x: double\n"
          "@kwarg svdim_x: length of subvolumes in x-direction\n"
          "@type svdim_y: double\n"
          "@kwarg svdim_y: length of subvolumes in y-direction\n"
        )
      )
      .def(self_ns::str(self))
      ;
//      boost::python::implicitly_convertible<BoxWithLines2DSubVol, AVolume2D>();
    }



