# -*- coding: utf-8 -*-
#
# cobra documentation build configuration file, created by
# sphinx-quickstart on Wed Jun 13 19:17:34 2012.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath('..'))


# In order to build documentation that requires libraries to import
class Mock(object):
    def __init__(self, *args, **kwargs):
        return

    def __call__(self, *args, **kwargs):
        return Mock()

    @classmethod
    def __getattr__(cls, name):
        if name in ('__file__', '__path__'):
            return '/dev/null'
        else:
            return Mock()

MOCK_MODULES = ['numpy', 'scipy', 'scipy.sparse', 'scipy.io', 'scipy.stats',
                'glpk', 'gurobipy', 'gurobipy.GRB', 'cplex', 'pp', 'libsbml',
                'cplex.exceptions', 'pandas']
for mod_name in MOCK_MODULES:
    sys.modules[mod_name] = Mock()

# -- General configuration ----------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.intersphinx',
              'sphinx.ext.mathjax', 'sphinx.ext.viewcode',
              'sphinx.ext.napoleon', 'sphinx.ext.mathjax', 'nbsphinx']

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'cobra'
copyright = u'2016, Daniel Robert Hyduke and Ali Ebrahim'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
from cobra.version import get_version, read_release_version
version = read_release_version()
# The full version, including alpha/beta/rc tags.
release = get_version()

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['_build', 'version.py', '.ipynb_checkpoints']

pygments_style = 'sphinx'


# -- Options for HTML output --------------------------------------------------

mathjax_path = 'https://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML'

# -- Options for LaTeX output --------------------------------------------------

latex_elements = {
# The paper size ('letterpaper' or 'a4paper').
'papersize': 'letterpaper',

# The font size ('10pt', '11pt' or '12pt').
#'pointsize': '10pt',

# Additional stuff for the LaTeX preamble.
'preamble': r'\usepackage{amsmath,amssymb}',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
  ('index', 'cobra.tex', u'cobra Documentation',
   u'Daniel Robert Hyduke and Ali Ebrahim', 'manual'),
]

# -- Options for manual page output --------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('index', 'cobra', u'cobra Documentation',
     [u'Daniel Robert Hyduke and Ali Ebrahim'], 1)
]

# -- Options for Texinfo output ------------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
  ('index', 'cobra', u'cobra Documentation',
   u'Daniel Robert Hyduke and Ali Ebrahim', 'cobra',
   'A package for constraints-based modeling of biological networks',
   'Miscellaneous'),
]

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {"http://docs.python.org/": None,
                       "http://docs.scipy.org/doc/numpy/": None,
                       "http://docs.scipy.org/doc/scipy/reference": None}
intersphinx_cache_limit = 10     # days to keep the cached inventories
