boltons Changelog
=================

Since February 20, 2013 there have been 28 releases and 950 commits for
an average of one 34-commit release every 6.4 weeks.

16.4.1
------
*(June 14, 2016)*

This release primarily contains several [statsutils][statsutils] updates.

* The biggest change was the addition of
  [Stats.format_histogram][statsutils.Stats.format_histogram] complete
  with Freedman bin selection and other useful options.
* Added inter-quartile range (iqr) to [statsutils.Stats][statsutils.Stats]
* Adding mad (median absolute deviation) to
  [Stats.describe][statsutils.Stats.describe], since median and
  std_dev were already there.

16.4.0
------
*(June 8, 2016)*

another significant release, thanks to the addition of funcutils.wraps
and funcutils.FunctionBuilder. also iterutils.chunked speedup, and
tbutils.ParsedException.to_string.

  * [funcutils.wraps][funcutils.wraps]: Just like functools.wraps, but
    can preserve the function signature as well.
  * [funcutils.FunctionBuilder][funcutils.FunctionBuilder]: The basis
    for [funcutils.wraps][funcutils.wraps], this full-featured type
    enables programmatically creating functions, from scratch or from
    existing functions. Supports all Python 2 and 3 function features.
  * [ecoutils][ecoutils]: Python 2.4 and 2.5 support.
  * [iterutils][iterutils]: optimize
    [iterutils.chunked_iter][iterutils.chunked_iter] (2-5x faster
    depending on runtime). [See #79][i79].
  * [tbutils][tbutils]: add the
    [ParsedException.to_string][tbutils.ParsedException.to_string]
    method, to convert parsed exceptions back into strings, possibly
    after manipulation
  * switch FunctionBuilder on Python 2 to be congruent with Python 3
    (keywords attribute renamed to varkw, preview users might have to
    adjust)

16.3.1
------
*(May  24, 2016)*

Just a couple of [ecoutils][ecoutils] follow-ons, removing uuid
dependency and adding the ability to scrub identifiable data.

16.3.0
------
*(May  23, 2016)*

Big, big update. Lots of additions, a few bugfixes.

* [ecoutils][ecoutils] - Python runtime/environment profile generator
* [timeutils.strpdate][timeutils.strpdate] - like datetime.datetime.strpdate but for date
* [timeutils.daterange][timeutils.daterange] - like range() but for datetime.date objects
* [strutils.parse_int_list][strutils.parse_int_list]
  and [strutils.format_int_list][strutils.format_int_list]
* [cacheutils][cacheutils]
  * [cachedproperty][cacheutils.cachedproperty]
  * [cacheutils.cachedmethod][cacheutils.cachedmethod]
  * [cacheutils.cached][cacheutils.cached] now accepts a callable, as well.
  * ``cacheutils.make_cache_key`` is now public, should others need it
* [statsutils.Stats][statsutils.Stats] update, several new methods,
  including [Stats.describe][statsutils.Stats.describe]
* A few [socketutils][socketutils] platform tweaks
* `debugutils.wrap_trace` preview

16.2.2
------
*(May 3, 2016)*

many small tweaks to socketutils.BufferedSocket, including optional
inclusion of the delimiter in recv_until. also undid the enabling of bak
files with AtomicSaver on windows

  * Small [socketutils.BufferedSocket][socketutils.BufferedSocket] tweaks
    * make recv_until conditionally return the delimiter (by default it
      does not). also fix a NetstringException inheritance typo
    * [socketutils][socketutils]: rename BufferedSocket.recv_lock to
      _recv_lock, and same for send_lock.
    * add a bunch of simple passthrough methods to better fill out
      socket's API
    * add .fileno/.close/.shutdown to [socketutils.BufferedSocket][socketutils.BufferedSocket]
    * added type/family/proto
      [socketutils.BufferedSocket][socketutils.BufferedSocket]
      passthrough properties
    * BufferedSocket: also lock on .shutdown()
    * adding an rbuf_unconsumed attribute for post-close debugging, per
      @doublereedkurt's request
    * `getsendbuffer()` returns a bytestring and `recv_size()` uses the proper
      `._recvsize` on the first socket fetch
  * [fileutils.AtomicSaver][fileutils.AtomicSaver]: revert bak file as
    it was causing confusion, per [nvie/pip-tools#351](https://github.com/nvie/pip-tools/issues/351)


16.2.1
------
*(April 29, 2016)*

This version sees the soft debut of [socketutils][socketutils], which
includes wrappers and tools for working with the built-in socket. A
lot of [socketutils.BufferedSocket][socketutils.BufferedSocket] changes.

  * [BufferedSocket.recv_until][socketutils.BufferedSocket.recv_until] now
    supports multibyte delimiters and also includes the delimiter in its returns.
  * Better BufferedSocket timeout discipline throughout.
  * Various BufferedSocket argument name changes, *maxbytes* became
    *maxsize*, *n* became *size*, *marker* became *delimiter*, etc.
  * [BufferedSocket][socketutils.BufferedSocket] BufferedSocket became
    threadsafe
  * [BufferedSocket.recv][socketutils.BufferedSocket.recv] now always returns the
    contents of the internal buffer before doing a socket call.
  * [BufferedSocket.recv_close][socketutils.BufferedSocket.recv_close] now exists
    to receive until the sending end closes the connection.
  * Can now pass *recvsize* to
    [BufferedSocket][socketutils.BufferedSocket] constructor to tune
    the size passed to the lower-level recv call.
  * [socketutils][socketutils] got documented and tested.

16.2.0
------
*(April 18, 2016)*

adding shell args escaper-joiners to strutils (escape_shell_args,
args2cmd, args2sh) as well as a rare breaking fix to
[iterutils.pairwise][iterutils.pairwise].

  * Argument joiners, functions to join command line arguments in
    context-appropriate ways:
    * [strutils.escape_shell_args][strutils.escape_shell_args]
    * [strutils.args2cmd][strutils.args2cmd]
    * [strutils.args2sh][strutils.args2sh]
  * BREAKING: finally fixing
    [iterutils.pairwise][iterutils.pairwise]. pairwise used to call to
    `chunked`, now it calls to `windowed`. `pairwise([1, 2, 3, 4])` no
    longer returns `[(1, 2), (3, 4)]`. Instead, it returns
    `[(1, 2), (2, 3), (3, 4)]`, which is what I always mean when I say
    pairwise, but not what the original contributor implemented.
  * Adding a universal wheel distribution option!

16.1.1
------
*(March 6, 2016)*

Added [iterutils.same][iterutils.same], improvement of Windows
[fileutils.AtomicSaver][fileutils.AtomicSaver] behavior for old
filesystems, bugfix on [strutils.is_uuid][strutils.is_uuid], expansion
of [strutils.pluralize][strutils.pluralize], new trove classifiers and
docs improvements!

  * [fileutils.replace][fileutils.replace]: use bak file option for
    win32 ReplaceFile for slightly better corner case coverage on less
    featureful filesystems
  * [strutils.pluralize][strutils.pluralize]: Add more irregular plurals
  * [strutils.is_uuid][strutils.is_uuid]: Catch un-parsable UUIDs.
  * [iterutils.same][iterutils.same]: Return `True` when all values in
    iterable are the same.


16.1.0
------
*(February 24, 2016)*

The centerpiece of this release is highly improved Windows support for
[fileutils.atomic_save][fileutils.atomic_save] via
[ReplaceFile](https://msdn.microsoft.com/en-us/library/windows/desktop/aa365512%28v=vs.85%29.aspx)
system call. This functionality is also made available directly via
[fileutils.replace][fileutils.replace], which is akin to Python 3.3+'s
[os.replace][os.replace], except that `os.replace`'s approach has
[arguably poorer behavior and atomicity](http://stupidpythonideas.blogspot.com/2014/07/getting-atomic-writes-right.html)
compared to `fileutils.replace`.

Also, a couple new strutils, and
[iterutils.backoff][iterutils.backoff] grew a jitter argument.

  * [iterutils.backoff][iterutils.backoff] now supports start=0
  * More comprehensive [iterutils.backoff][iterutils.backoff] argument checking/validation
  * [fileutils.replace][fileutils.replace] and
    [fileutils.atomic_rename][fileutils.atomic_rename] are now public
    functions in [fileutils][fileutils] with cross-platform implementations ([discussion here](https://github.com/mahmoud/boltons/issues/60))
  * [tableutils.Table][tableutils.Table]s have a metadata argument and
    attribute for miscellaneous metadata.
  * [strutils.is_ascii][strutils.is_ascii] and
    [strutils.is_uuid][strutils.is_uuid]: About as straightforward as
    they are handy.
  * Tox testing improvements


16.0.1
------
*(January 24, 2016)*

DummyFile, Table.metadata, better exception handling, and in-progress
iterutils.get_path

  * Small format fix in [iterutils.one][iterutils.one] for None
  * Initial implementation of
    [fileutils.DummyFile][fileutils.DummyFile], which allows for easy
    no-op file handling without restructuring code. Sort of like a
    dummy RLock for systems without threading, if you've seen those.
  * avoid catching BaseException in all boltons
  * better error handling in iterutils.get_path

16.0.0
------

One important fix and one small but handy string function.

* Fixed an [LRU][cacheutils.LRU] bug related to the 15.1.1
  refactor. Also enhanced LRU testing with doubly-linked list
  invariant enforcement.
* Added [strutils.indent][strutils.indent], the counterpart to
  [textwrap.dedent](https://docs.python.org/2/library/textwrap.html#textwrap.dedent).

15.1.1
------
*(November 18, 2015)*

A lot of bugfixes and docfixes in 15.1.1.

updated AtomicSaver for better permissions handling, update
BufferedSocket message sending, beta version of iterutils.get_path,
several docs fixes, Stats zscore and cache bugfix, and an LRU refactor
with significantly improved behavior and code factoring.

  * Updated [fileutils.AtomicSaver][fileutils.AtomicSaver] handling of
    filesystem permissions to be simpler and more secure. This also
    merges `dest_perms` and `part_perms` arguments to AtomicSaver and
    atomic_save.
  * Fix large message sending with [socketutils.BufferedSocket][socketutils.BufferedSocket]
  * [strutils.iter_splitlines][strutils.iter_splitlines] is now in the docs.
  * [cacheutils][cacheutils]: now imports RLock from the right place for python 2
  * [statsutils][statsutils]: Only `delattr` when `hasattr` in
    [Stats.clear_cache][statsutils.Stats.clear_cache]
  * [statsutils.Stats][statsutils.Stats]: Add
    [Stats.get_zscore][statsutils.Stats.get_zscore] to support
    calculating the [z-score][zscore] (see also: t-statistic)
  * [cacheutils.LRU][cacheutils.LRU]: Massive refactor of the backing
    linked list for better handling of duplicate data in the
    cache. More aggressive locking and better `__eq__`

15.1.0
------
*(September 23, 2015)*

Reached the first release version of
[iterutils.remap][iterutils.remap](), fully tested and
documented. Also a couple of tweaks to expose the
[iterutils.unique][iterutils.unique] docs.

15.0.2
------
*(September 9, 2015)*

a couple [dictutils.OMD][dictutils.OMD] fixes to
[dictutils.OMD.pop][dictutils.OMD.pop] and
[dictutils.OMD.popall][dictutils.OMD.popall] to make them consistent
with the docstrings. and the accompanying tests of course.

* fix [dictutils.OMD.setdefault][dictutils.OMD.setdefault] to default
to None and not empty list, per documentation (and add a test to the
same effect)


15.0.1
------
*(August 27, 2015)*

* Added
  [OrderedMultiDict.sortedvalues()][OrderedMultiDict.sortedvalues],
  which returns a copy of the OMD with sublists within a keyspace
  sorted.
* Fixing a bug in
  [dictutils.OrderedMultiDict][dictutils.OrderedMultiDict]'s addlist
  method that caused values to be added multiple times.
* Fixing a [iterutils.backoff][iterutils.backoff] string identity check

[OrderedMultiDict.sortedvalues]: http://boltons.readthedocs.org/en/latest/dictutils.html#boltons.dictutils.OrderedMultiDict.sortedvalues

15.0.0
------
*(August 19, 2015)*

Finally the 15.0 major release. All passing PRs and feature requests
from the first wave addressed and closed. tzutils merged into
timeutils. AtomicSaver approach and API much improved. Several other
features added:

  * [iterutils.backoff][iterutils.backoff] and [iterutils.backoff_iter][iterutils.backoff_iter] for exponential backoff
  * [iterutils.frange][iterutils.frange] and [iterutils.xfrange][iterutils.xfrange] for floating point range generation
  * Slightly more permissive [jsonutils.JSONLIterator][jsonutils.JSONLIterator] blank line ignoring
  * [strutils.iter_splitlines][strutils.iter_splitlines] for lazily getting lines from a larger string
  * [timeutils.dt_to_timestamp][timeutils.dt_to_timestamp], per the long-lived PR [#13][i13].
  * Merged tzutils into timeutils
  * [fileutils.AtomicSaver][fileutils.AtomicSaver] rewrite and redoc
  * -teens support for [strutils.ordinalize][strutils.ordinalize]
  * made [iterutils.one][iterutils.one] consistent with [iterutils.first][iterutils.first]


0.6.6
-----
*(July 31, 2015)*

Fix atomic saving open-file issue for Windows.

  * Patch for AtomicSaver on Windows. Full rewrite comes in 15.0.0.
  * [strutils.gunzip_bytes][strutils.gunzip_bytes] for decompressing a gzip bytestring


0.6.5
-----
*(July 30, 2015)*

BufferedSocket work, html2text, pairwise shortcut, is_container, plural
typo fix, [timeutils.isoparse][timeutils.isoparse], [cacheutils.ThresholdCounter][cacheutils.ThresholdCounter], and lots of
testing

  * Add [iterutils.first][iterutils.first] function
  * Add [cacheutils.ThresholdCounter][cacheutils.ThresholdCounter]
  * Add JSONL verification to jsonutils
  * Add [timeutils.isoparse][timeutils.isoparse]
  * Add [strutils.html2text][strutils.html2text] and [strutils.HTMLTextExtractor][strutils.HTMLTextExtractor]
  * Fix [strutils.pluralize][strutils.pluralize] (indeces -> indices, per [#41][i41])
  * Add [iterutils.is_container][iterutils.is_container] function
  * Fixed a small formatting bug in [tbutils.ExceptionInfo][tbutils.ExceptionInfo] that added
    an extra 'builtins.' for builtin exceptions under python 3
  * Added tests for many modules
  * Create [iterutils.pairwise][iterutils.pairwise] shortcuts for pairwise chunks since
    pairs (key/val) are common
  * Additional 2.6 compatibility and tests
  * Fixed CachedInstancePartial to be Python 3 friendly without breaking
    PyPy.
  * Made formatutils Python 3 compatible
  * Rename sockutils to socketutils and other changes


0.6.4
-----
*(May 10, 2015)*

Fixed multiline exception message handling in ParsedException. added
mathutils. adding a tentative version of socketutils. fix LRU.popitem. fix
OMD.__eq__.

  * Fix a bug where [dictutils.OrderedMultiDict][dictutils.OrderedMultiDict]'s __eq__ would fail
    with non-iterable objects of comparison
  * Fixed `LRU.popitem` to return a key value pair
  * Added mathutils with [mathutils.ceil][mathutils.ceil] and [mathutils.floor][mathutils.floor]
    implementations that can search a fixed set of choices using the
    bisect module.
  * Fix [excutils.ParsedException][excutils.ParsedException] so exception message would not start
    with whitespace
  * Fix multiline exception messages
  * Adding [socketutils.BufferedSocket][socketutils.BufferedSocket] and [socketutils.NetstringSocket][socketutils.NetstringSocket]


0.6.3
-----
*(April 20, 2015)*

Add typeutils, remove compat.py, make ParsedException work with eval()ed
code

  * Properly parse tracebacks with missing source.  Resolves [#30][i30]
  * Tweak the docs for [typeutils.get_all_subclasses][typeutils.get_all_subclasses]
  * Moved [typeutils.make_sentinel][typeutils.make_sentinel] into typeutils and removed the
    confusing compat module
  * Add in typeutils with modifications per the caveats of [#15][i15]
  * Added function [iterutils.one][iterutils.one]

0.6.2
-----
*(April 11, 2015)*

Add partial_ordering, fix LRU repr and addition behavior

  * Add [funcutils.partial_ordering][funcutils.partial_ordering](), decorator similar to
    functools.total_ordering()
  * Fixed [cacheutils.LRU][cacheutils.LRU]'s behavior per [#21][i21]
  * Fix [cacheutils.LRU][cacheutils.LRU] repr reversal, fixes [#20][i20]

0.6.0
-----
*(April 10, 2015)*

Python 3 support and several community bugfixes. Docs clarifications, too.

  * Make boltons Python 3 compatible without any external
    dependencies. All modules are independent and work in Python 2.6,
    2.7, 3.4, and PyPy.
  * clarify TracebackInfo.from_current() method gap, per user 'dl__'
    here: http://www.reddit.com/r/Python/comments/321d3o/boltons_over_100_python_utilities/
  * Fix the [cacheutils.cached][cacheutils.cached] decorator, adding a sanity test, fixes [#12][i12]
  * Fix bytes2human when builtin zip returns iterators
  * Simplified logic of [iterutils.chunked][iterutils.chunked]

0.5.1
-----
*(April 10, 2015)*

A lot of bugfixes and Python 2.6 and PyPy compatibility changes thanks
to community contributions and encouragement.

  * Corrected cases where OMD was not exactly a dropin for OrderedDict
  * conditional availability of [gcutils.get_all][gcutils.get_all] based on pypy or cpython, also
    [gcutils.is_tracked][gcutils.is_tracked] was added in 2.7, so making [gcutils.get_all][gcutils.get_all] work with 2.6
  * Made namedutils backwards compatibilty for python 2.6 best effort
  * Fix invalid part_path usage in [fileutils.AtomicSaver][fileutils.AtomicSaver]

0.5.0
-----
*(April  9, 2015)*

First publicly released version. The major focus of this release was
docs, docstrings, and Read The Docs.

  * Cleared out __init__ module for maximum independence
  * making [statsutils.median][statsutils.median] use _get_quantile and add [statsutils.trimean][statsutils.trimean]
  * Switching the [statsutils.Stats][statsutils.Stats] type to be more sorted-data oriented, since it's
    only for offline analysis of unordered data
  * Made consistent multi-line string formats, as well as usage of the
    term 'builtin' vs 'built-in' (noun vs adjective)
  * Instrumented LRI with stats tracking
  * Made [timeutils.decimal_relative_time][timeutils.decimal_relative_time] cardinalization optional
  * Removed timeutils dependency on strutils
  * Made [tbutils.TracebackInfo][tbutils.TracebackInfo] classmethods work with no arguments.
  * Renamed ParsedTB to [tbutils.ParsedException][tbutils.ParsedException]
  * Made [dictutils.OMD][dictutils.OMD] .get()/.getlist() semantics more consistent.
  * finalizing .todict() and adding .sorted() to the [dictutils.OMD][dictutils.OMD]
  * Removed osutils and adding a note about utils in general
  * Made cacheutils more consistent between LRU and LRI, adding some
    cacheutils docs
  * Deprecate osutils, moving its contents into fileutils
  * Adding in-process statsutils2, with new DataAnalyzer and
    get_pearson_type (not merged yet)


0.4.2
-----
*(March  8, 2015)*

Mostly a dictutils API update (addlist), but also gcutils.

  * [dictutils.OMD][dictutils.OMD]: split out addlist() from add(), removing the multi
    kwarg
  * adding gcutils with [gcutils.GCToggler][gcutils.GCToggler] and gc.get_all


0.4.1
-----
*(February 26, 2015)*

adding mboxutils

  * adding mboxutils for handy dandy /var/mail integrations like cronfed


0.4.0
-----
*(February 23, 2015)*

updated tbutils, JSONL support, initial cacheutils, atomic writer,
hashtags

  * tbutils: Changed the way exceptions are parsed out of tracebacks
  * tbutils: Guard against potential linecache issues
  * Defined/implemented [iterutils.windowed_iter][iterutils.windowed_iter] corner case behavior
  * Added from_path to [fileutils.FilePerms][fileutils.FilePerms]
  * Adding [strutils.find_hashtags][strutils.find_hashtags]
  * Add ignore patterns to [fileutils.iter_find_files][fileutils.iter_find_files]


0.3.0
-----
*(October 19, 2014)*

First alpha release. Practically, everything not mentioned above was
added in this release.

  * tbutils: add ContextualTracebackInfo and ContextualExceptionInfo
  * cacheutils: a few minor changes to the BasicCache
  * update tbutils with some critical bits. still need to add
    convenience method for ExceptionInfo -> default exception print,
    also need to add more docstrings.
  * adding initial jsonutils with JSONL support
  * added [cacheutils.LRU][cacheutils.LRU]
  * added [timeutils.parse_timedelta][timeutils.parse_timedelta]
  * fixing iteritems with multi=False in the
    [dictutils.OrderedMultiDict][dictutils.OrderedMultiDict] (should return first key, but last
    value not first)
  * debugutils: add pdb excepthook and [debugutils.pdb_on_signal][debugutils.pdb_on_signal]
  * add [fileutils.mkdir_p][fileutils.mkdir_p]
  * tableutils: add maxlen to table text stuff
  * fix date citation for gob's
  * adding pure-Python implementation of Gob's algorithm
  * fix object header guessing
  * namedutils: add namedtuple support
  * fix a headers bug in tableutils
  * tableutils: add a couple more do-not-recurse types, add
    UnsupportedData exception for better recursion, insert recursive
    entries in-line, improve 'Object' strategy heuristic
  * wrap up html tag customization and fix a related bug
  * make html configurable via class attributes
  * strengthen the max_depth check
  * InputType classes are just shorter and clearer, imo
  * new from_dict, from_list, from_object, removing old ones. almost
    used a MetaClass for this
  * starting new table
  * only update the integer for the field being updated
  * fixing a verbalization/pronunciation issue
  * no regex for better error messages
  * being opinionated about some FilePerms things
  * adding initial version of fileutils/FilePerms
  * update formatutils
  * fix a slightly nasty namedlist bug
  * make OrderedMultiDict.get()'s default allow singulars
  * sync over ExceptionInfo
  * add from_current() classmethod with depth option to Callpoint class
    for easier instantiation
  * it's called a numeronym
  * add a repr to ParsedTB. A bit verbose, but better than nothing.
  * add ParsedTB, which provides the ability to parse tracebacks dumped
    out to logs, the command line, etc.
  * improve test output and make assertion that new except hook is the
    same as the builtin.
  * update tbutils to use the more-powerful Callpoint type.
  * copy_function
  * partially clean up partial stuff
  * first version of the namedlist
  * fixing up namedtuple, groundwork for namedlist. humorously named
    module.
  * embed value in cell for incremental iteration boost on OMD
  * reorganize code, add 'default' argument to poplast()
  * make key argument optional to OMD.poplast
  * rectifying inconsistent names and adjusting respective tests
    accordingly. using smashcase because that's what builtin dict()
    uses.
  * fix reverse; missing yield from!
  * add initial table biz
  * add get_counts
  * add [dictutils.OrderedMultiDict.get_inverted][dictutils.OrderedMultiDict.get_inverted]() for those handy reverse lookups
  * break out skip list to FastIter OMD + bench
  * add [strutils.a10n][strutils.a10n]()
  * fix a bug in [dictutils.OrderedMultiDict][dictutils.OrderedMultiDict]'s .add()
  * adding initial reimplementation of OMD
  * adding some tests to dictutils
  * update boltons formatutils to match what's goin on in lithoxyl
  * remove infer_pos_args() from strutils (already in formatutils)
  * add formatutils to boltons
  * fix a potential infinite recursion in LocalTZ
  * use more explicit names for Local/Constant tzinfo types
  * add a basic but handy file finder
  * add infer_positional_args() to strutils (from lithoxyl)
  * split BasicCache out of dictutils into cacheutils
  * update median calculation slightly
  * add appropriate stacklevel to deprutils warning
  * add an initial version of deprutils (basic utils for facilitating
    deprecation)
  * add bytes2human
  * first version of some basic timezone utils which came in handy for a
    train scheduling application I wrote (etavta)
  * reorder imports for pep8
  * redo plain-english relative_time() to have a decimal rounding factor
    and handle future dates
  * swap the order of cardinalize()'s arguments after intuiting the
    wrong order a couple times. gotta be consistent, this isn't PHP.
  * a weird little relative time approach
  * add total_seconds() implementation for Python <2.7, rename
    relative_datetime to relative_time
  * add a relative datetime function in a new module: timeutils
  * a little more transparency with orderedmultidict's maphistory
  * add a test for BasicCache
  * add the super simple BasicCache, a size-limited defaultdict-like
    thing
  * add a cheesy little splay list construct that can be used for splay-
    like manual reordering for eventual optimization
  * traceback utils, first draft
  * add strip_ansi() (need to make a cliutils or something)
  * add ansi strip task
  * mess with list tuning
  * add ordinalize()
  * add __all__ to statsutils
  * add more stats docs and doctests
  * add some stats functions
  * add unit_len()
  * add pluralize/singularize/cardinalize to strutils
  * add __all__s all around, clean up imports a bit
  * adding license
  * add sorted queue type, make it the default
  * fix little bug in insert
  * inheriting from list necessitates overriding the deprecated __get-,
    __set-, and __del- slice methods
  * hacky refactor to have a BasePriorityQueue to make room for
    SortedPriorityQueue with peek_n, etc.
  * add a little docstring and update sort method in BarrelList
  * add HeapPriorityQueue
  * tidy up listutils comments and imports
  * move treeutils out of boltons since I don't really think a pure
    python version actually adds much. i'll make an academic one-off
    repo for less practical data structure experiments like that.
  * inherit from list
  * add reverse() to blist
  * add index() to blist
  * cheesy __setitem__() for blist
  * add __delitem__() to BarrelList
  * change the way the in-place sort works with just one list
  * tune the list size a bit
  * add slicing to BarrelList
  * add initial version of BarrelList, a pure-python b-list-y thing to
    approximate O(log(n)) behavior by multiplexing the fast O(n) list
    operations
  * switch to new dead index interval approach; the IndexedSet is about
    half the speed of a list in the ultra-pathological case of random
    popping on the low end of the IndexedSet
  * made BisectTree's get() defaulting work a bit more like a dict's
  * added get_adjacent and miscellaneous to BisectTree
  * added a default name and always-falsy __nonzero__ to Sentinel
  * add pop() for BisectTree and export the generic Tree
  * make a bisect tree, because O(n) is still pretttttty fast up to
    about 100k items
  * add a little hack to chunked/chunked_iter to make it work nicely
    with strings
  * tidy up ki_vs_vi_lrh usage just a titch
  * revamp indices behavior (key_size and value_size)
  * switch to new multi-key mode
  * pretty much done porting insert, delete, balance (the basic
    operations)
  * switch to negative refs, arbitrary length nodes
  * add sentinel utility thing
  * add .index() for list compat, updated exception messages, and added
    a silly test to show off slicing and indexing
  * add slicing support and .clear()
  * remove ifilter dependency (using generator expression)
  * add .reverse and .sort() to IndexedSet, fix bisection related bug
    exposing MISSING (insort requested index, not real_index)
  * pretty much all fundy IndexedSet bugs hit and fixed, looks like
  * IndexedSet getting much closer
  * initial rough draft of IndexedSet with a short docstring and a bunch
    of fixes already (still not workin tho)
  * add dictutils (OrderedMultiDict)
  * it was a long time coming, but I'm finally halfway happy with this
    wrapped exception
  * add uniqueification capabilities
  * go back to using __new__ and positional arguments
  * exception wrapping green path mostly working
  * working on a wrapping exception mixin thing for less lossy
    nonraising.
  * add asciify and update slugify with ascii flag
  * add basic docs and doctests to strutils
  * scratch that, regexes still faster
  * add under2camel, camel2under, and slugify (and split_punct_ws, which
    is much faster than re-based punctuation splitting)
  * python3-compatible doctest for bucketize_bool
  * bucketize and bucketize_bool, with docs
  * add examples to chunked and chunked_iter
  * update split() docs with more examples.
  * [iterutils.chunked_iter][iterutils.chunked_iter] and [iterutils.chunked][iterutils.chunked]
  * [iterutils.split][iterutils.split] and [iterutils.split_iter][iterutils.split_iter] work


[os.replace]: https://docs.python.org/3/library/os.html#os.replace

[cacheutils]: http://boltons.readthedocs.org/en/latest/cacheutils.html
[cacheutils.LRU]: http://boltons.readthedocs.org/en/latest/cacheutils.html#boltons.cacheutils.LRU
[cacheutils.ThresholdCounter]: http://boltons.readthedocs.org/en/latest/cacheutils.html#boltons.cacheutils.ThresholdCounter
[cacheutils.cached]: http://boltons.readthedocs.org/en/latest/cacheutils.html#boltons.cacheutils.cached
[cacheutils.cachedmethod]: http://boltons.readthedocs.org/en/latest/cacheutils.html#boltons.cacheutils.cachedmethod
[cacheutils.cachedproperty]: http://boltons.readthedocs.org/en/latest/cacheutils.html#boltons.cacheutils.cachedproperty
[debugutils.pdb_on_signal]: http://boltons.readthedocs.org/en/latest/debugutils.html#boltons.debugutils.pdb_on_signal
[dictutils.OMD]: http://boltons.readthedocs.org/en/latest/dictutils.html#boltons.dictutils.OMD
[dictutils.OMD.pop]: http://boltons.readthedocs.org/en/latest/dictutils.html#boltons.dictutils.OrderedMultiDict.pop
[dictutils.OMD.popall]: http://boltons.readthedocs.org/en/latest/dictutils.html#boltons.dictutils.OrderedMultiDict.popall
[dictutils.OMD.setdefault]: http://boltons.readthedocs.org/en/latest/dictutils.html#boltons.dictutils.OrderedMultiDict.setdefault
[dictutils.OrderedMultiDict]: http://boltons.readthedocs.org/en/latest/dictutils.html#boltons.dictutils.OrderedMultiDict
[dictutils.OrderedMultiDict.get_inverted]: http://boltons.readthedocs.org/en/latest/dictutils.html#boltons.dictutils.OrderedMultiDict.get_inverted
[ecoutils]: http://boltons.readthedocs.org/en/latest/ecoutils.html
[excutils.ParsedException]: http://boltons.readthedocs.org/en/latest/excutils.html#boltons.excutils.ParsedException
[fileutils]: http://boltons.readthedocs.org/en/latest/fileutils.html
[fileutils.replace]: http://boltons.readthedocs.org/en/latest/fileutils.html#boltons.fileutils.replace
[fileutils.atomic_rename]: http://boltons.readthedocs.org/en/latest/fileutils.html#boltons.fileutils.atomic_rename
[fileutils.atomic_save]: http://boltons.readthedocs.org/en/latest/fileutils.html#boltons.fileutils.atomic_save
[fileutils.AtomicSaver]: http://boltons.readthedocs.org/en/latest/fileutils.html#boltons.fileutils.AtomicSaver
[fileutils.FilePerms]: http://boltons.readthedocs.org/en/latest/fileutils.html#boltons.fileutils.FilePerms
[fileutils.iter_find_files]: http://boltons.readthedocs.org/en/latest/fileutils.html#boltons.fileutils.iter_find_files
[fileutils.mkdir_p]: http://boltons.readthedocs.org/en/latest/fileutils.html#boltons.fileutils.mkdir_p
[fileutils.DummyFile]: http://boltons.readthedocs.org/en/latest/fileutils.html#boltons.fileutils.DummyFile
[funcutils.FunctionBuilder]: http://boltons.readthedocs.org/en/latest/funcutils.html#boltons.funcutils.FunctionBuilder
[funcutils.partial_ordering]: http://boltons.readthedocs.org/en/latest/funcutils.html#boltons.funcutils.partial_ordering
[funcutils.wraps]: http://boltons.readthedocs.org/en/latest/funcutils.html#boltons.funcutils.wraps
[gcutils.GCToggler]: http://boltons.readthedocs.org/en/latest/gcutils.html#boltons.gcutils.GCToggler
[gcutils.get_all]: http://boltons.readthedocs.org/en/latest/gcutils.html#boltons.gcutils.get_all
[gcutils.is_tracked]: http://boltons.readthedocs.org/en/latest/gcutils.html#boltons.gcutils.is_tracked
[i12]: https://github.com/mahmoud/boltons/issues/12
[i13]: https://github.com/mahmoud/boltons/issues/13
[i15]: https://github.com/mahmoud/boltons/issues/15
[i20]: https://github.com/mahmoud/boltons/issues/20
[i21]: https://github.com/mahmoud/boltons/issues/21
[i30]: https://github.com/mahmoud/boltons/issues/30
[i41]: https://github.com/mahmoud/boltons/issues/41
[i79]: https://github.com/mahmoud/boltons/pull/79
[iterutils]: http://boltons.readthedocs.org/en/latest/iterutils.html
[iterutils.backoff]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.backoff
[iterutils.backoff_iter]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.backoff_iter
[iterutils.chunked]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.chunked
[iterutils.chunked_iter]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.chunked_iter
[iterutils.first]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.first
[iterutils.backoff]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.backoff
[iterutils.frange]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.frange
[iterutils.is_container]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.is_container
[iterutils.one]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.one
[iterutils.pairwise]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.pairwise
[iterutils.same]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.same
[iterutils.remap]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.remap
[iterutils.split]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.split
[iterutils.split_iter]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.split_iter
[iterutils.unique]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.unique
[iterutils.windowed_iter]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.windowed_iter
[iterutils.xfrange]: http://boltons.readthedocs.org/en/latest/iterutils.html#boltons.iterutils.xfrange
[jsonutils.JSONLIterator]: http://boltons.readthedocs.org/en/latest/jsonutils.html#boltons.jsonutils.JSONLIterator
[mathutils.ceil]: http://boltons.readthedocs.org/en/latest/mathutils.html#boltons.mathutils.ceil
[mathutils.floor]: http://boltons.readthedocs.org/en/latest/mathutils.html#boltons.mathutils.floor
[socketutils]: http://boltons.readthedocs.org/en/latest/socketutils.html
[socketutils.BufferedSocket]: http://boltons.readthedocs.org/en/latest/socketutils.html#boltons.socketutils.BufferedSocket
[socketutils.BufferedSocket.recv]: http://boltons.readthedocs.org/en/latest/socketutils.html#boltons.socketutils.BufferedSocket.recv
[socketutils.BufferedSocket.recv_until]: http://boltons.readthedocs.org/en/latest/socketutils.html#boltons.socketutils.BufferedSocket.recv_until
[socketutils.BufferedSocket.recv_close]: http://boltons.readthedocs.org/en/latest/socketutils.html#boltons.socketutils.BufferedSocket.recv_close
[socketutils.NetstringSocket]: http://boltons.readthedocs.org/en/latest/socketutils.html#boltons.socketutils.NetstringSocket
[statsutils]: http://boltons.readthedocs.org/en/latest/statsutils.html
[statsutils.Stats]: http://boltons.readthedocs.org/en/latest/statsutils.html#boltons.statsutils.Stats
[statsutils.Stats.clear_cache]: http://boltons.readthedocs.org/en/latest/statsutils.html#boltons.statsutils.Stats.clear_cache
[statsutils.Stats.describe]: http://boltons.readthedocs.org/en/latest/statsutils.html#boltons.statsutils.Stats.describe
[statsutils.Stats.format_histogram]: http://boltons.readthedocs.org/en/latest/statsutils.html#boltons.statsutils.Stats.format_histogram
[statsutils.Stats.get_zscore]: http://boltons.readthedocs.org/en/latest/statsutils.html#boltons.statsutils.Stats.get_zscore
[statsutils.median]: http://boltons.readthedocs.org/en/latest/statsutils.html#boltons.statsutils.median
[statsutils.trimean]: http://boltons.readthedocs.org/en/latest/statsutils.html#boltons.statsutils.trimean
[strutils.HTMLTextExtractor]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.HTMLTextExtractor
[strutils.a10n]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.a10n
[strutils.args2cmd]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.args2cmd
[strutils.args2sh]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.args2sh
[strutils.escape_shell_args]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.escape_shell_args
[strutils.find_hashtags]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.find_hashtags
[strutils.gunzip_bytes]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.gunzip_bytes
[strutils.html2text]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.html2text
[strutils.indent]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.indent
[strutils.iter_splitlines]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.iter_splitlines
[strutils.ordinalize]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.ordinalize
[strutils.pluralize]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.pluralize
[strutils.is_ascii]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.is_ascii
[strutils.is_uuid]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.is_uuid
[strutils.parse_int_list]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.parse_int_list
[strutils.format_int_list]: http://boltons.readthedocs.org/en/latest/strutils.html#boltons.strutils.format_int_list
[tableutils]: http://boltons.readthedocs.org/en/latest/tableutils.html
[tableutils.Table]: http://boltons.readthedocs.org/en/latest/tableutils.html#boltons.tableutils.Table
[tbutils]: http://boltons.readthedocs.org/en/latest/tbutils.html
[tbutils.ExceptionInfo]: http://boltons.readthedocs.org/en/latest/tbutils.html#boltons.tbutils.ExceptionInfo
[tbutils.ParsedException]: http://boltons.readthedocs.org/en/latest/tbutils.html#boltons.tbutils.ParsedException
[tbutils.ParsedException.to_string]: http://boltons.readthedocs.org/en/latest/tbutils.html#boltons.tbutils.ParsedException.to_string
[tbutils.TracebackInfo]: http://boltons.readthedocs.org/en/latest/tbutils.html#boltons.tbutils.TracebackInfo
[timeutils.daterange]: http://boltons.readthedocs.org/en/latest/timeutils.html#boltons.timeutils.daterange
[timeutils.decimal_relative_time]: http://boltons.readthedocs.org/en/latest/timeutils.html#boltons.timeutils.decimal_relative_time
[timeutils.dt_to_timestamp]: http://boltons.readthedocs.org/en/latest/timeutils.html#boltons.timeutils.dt_to_timestamp
[timeutils.isoparse]: http://boltons.readthedocs.org/en/latest/timeutils.html#boltons.timeutils.isoparse
[timeutils.parse_timedelta]: http://boltons.readthedocs.org/en/latest/timeutils.html#boltons.timeutils.parse_timedelta
[timeutils.strpdate]: http://boltons.readthedocs.org/en/latest/timeutils.html#boltons.timeutils.strpdate
[typeutils.get_all_subclasses]: http://boltons.readthedocs.org/en/latest/typeutils.html#boltons.typeutils.get_all_subclasses
[typeutils.make_sentinel]: http://boltons.readthedocs.org/en/latest/typeutils.html#boltons.typeutils.make_sentinel
[zscore]: https://en.wikipedia.org/wiki/Standard_score
