# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_check_at_subscription_scope_request(subscription_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))  # type: str
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions"
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_check_at_resource_group_scope_request(
    resource_group_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))  # type: str
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_check_at_management_group_scope_request(management_group_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    management_groups_namespace = kwargs.pop("management_groups_namespace", "Microsoft.Management")  # type: str
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))  # type: str
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "managementGroupsNamespace": _SERIALIZER.url("management_groups_namespace", management_groups_namespace, "str"),
        "managementGroupId": _SERIALIZER.url("management_group_id", management_group_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class PolicyRestrictionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.policyinsights.PolicyInsightsClient`'s
        :attr:`policy_restrictions` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def check_at_subscription_scope(
        self, parameters: _models.CheckRestrictionsRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a subscription.

        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckRestrictionsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def check_at_subscription_scope(
        self, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a subscription.

        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def check_at_subscription_scope(
        self, parameters: Union[_models.CheckRestrictionsRequest, IO], **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a subscription.

        :param parameters: The check policy restrictions parameters. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckRestrictionsRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CheckRestrictionsResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CheckRestrictionsRequest")

        request = build_check_at_subscription_scope_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.check_at_subscription_scope.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseAutoGenerated, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CheckRestrictionsResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_at_subscription_scope.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions"}  # type: ignore

    @overload
    def check_at_resource_group_scope(
        self,
        resource_group_name: str,
        parameters: _models.CheckRestrictionsRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a resource group. Use
        this when the resource group the resource will be created in is already known.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckRestrictionsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def check_at_resource_group_scope(
        self, resource_group_name: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a resource group. Use
        this when the resource group the resource will be created in is already known.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def check_at_resource_group_scope(
        self, resource_group_name: str, parameters: Union[_models.CheckRestrictionsRequest, IO], **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on a resource within a resource group. Use
        this when the resource group the resource will be created in is already known.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param parameters: The check policy restrictions parameters. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckRestrictionsRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CheckRestrictionsResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CheckRestrictionsRequest")

        request = build_check_at_resource_group_scope_request(
            resource_group_name=resource_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.check_at_resource_group_scope.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseAutoGenerated, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CheckRestrictionsResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_at_resource_group_scope.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions"}  # type: ignore

    @overload
    def check_at_management_group_scope(
        self,
        management_group_id: str,
        parameters: _models.CheckManagementGroupRestrictionsRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on resources within a management group.

        :param management_group_id: Management group ID. Required.
        :type management_group_id: str
        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckManagementGroupRestrictionsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword management_groups_namespace: The namespace for Microsoft Management RP; only
         "Microsoft.Management" is allowed. Default value is "Microsoft.Management". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype management_groups_namespace: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def check_at_management_group_scope(
        self, management_group_id: str, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on resources within a management group.

        :param management_group_id: Management group ID. Required.
        :type management_group_id: str
        :param parameters: The check policy restrictions parameters. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword management_groups_namespace: The namespace for Microsoft Management RP; only
         "Microsoft.Management" is allowed. Default value is "Microsoft.Management". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype management_groups_namespace: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def check_at_management_group_scope(
        self,
        management_group_id: str,
        parameters: Union[_models.CheckManagementGroupRestrictionsRequest, IO],
        **kwargs: Any
    ) -> _models.CheckRestrictionsResult:
        """Checks what restrictions Azure Policy will place on resources within a management group.

        :param management_group_id: Management group ID. Required.
        :type management_group_id: str
        :param parameters: The check policy restrictions parameters. Is either a model type or a IO
         type. Required.
        :type parameters: ~azure.mgmt.policyinsights.models.CheckManagementGroupRestrictionsRequest or
         IO
        :keyword management_groups_namespace: The namespace for Microsoft Management RP; only
         "Microsoft.Management" is allowed. Default value is "Microsoft.Management". Note that
         overriding this default value may result in unsupported behavior.
        :paramtype management_groups_namespace: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CheckRestrictionsResult or the result of cls(response)
        :rtype: ~azure.mgmt.policyinsights.models.CheckRestrictionsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        management_groups_namespace = kwargs.pop("management_groups_namespace", "Microsoft.Management")  # type: str
        api_version = kwargs.pop("api_version", _params.pop("api-version", "2022-03-01"))  # type: str
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.CheckRestrictionsResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "CheckManagementGroupRestrictionsRequest")

        request = build_check_at_management_group_scope_request(
            management_group_id=management_group_id,
            management_groups_namespace=management_groups_namespace,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.check_at_management_group_scope.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseAutoGenerated, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CheckRestrictionsResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_at_management_group_scope.metadata = {"url": "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions"}  # type: ignore
