# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class ProvisioningErrorCode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Error code of the provisioning failure
    """

    BAD_SOURCE_TYPE = "BadSourceType"
    BAD_PIR_SOURCE = "BadPIRSource"
    BAD_MANAGED_IMAGE_SOURCE = "BadManagedImageSource"
    BAD_SHARED_IMAGE_VERSION_SOURCE = "BadSharedImageVersionSource"
    BAD_CUSTOMIZER_TYPE = "BadCustomizerType"
    UNSUPPORTED_CUSTOMIZER_TYPE = "UnsupportedCustomizerType"
    NO_CUSTOMIZER_SCRIPT = "NoCustomizerScript"
    BAD_VALIDATOR_TYPE = "BadValidatorType"
    UNSUPPORTED_VALIDATOR_TYPE = "UnsupportedValidatorType"
    NO_VALIDATOR_SCRIPT = "NoValidatorScript"
    BAD_DISTRIBUTE_TYPE = "BadDistributeType"
    BAD_SHARED_IMAGE_DISTRIBUTE = "BadSharedImageDistribute"
    BAD_STAGING_RESOURCE_GROUP = "BadStagingResourceGroup"
    SERVER_ERROR = "ServerError"
    OTHER = "Other"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the resource
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    DELETING = "Deleting"

class ResourceIdentityType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity used for the image template. The type 'None' will remove any identities
    from the image template.
    """

    USER_ASSIGNED = "UserAssigned"
    NONE = "None"

class RunState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """State of the last run
    """

    RUNNING = "Running"
    CANCELING = "Canceling"
    SUCCEEDED = "Succeeded"
    PARTIALLY_SUCCEEDED = "PartiallySucceeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class RunSubState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Sub-state of the last run
    """

    QUEUED = "Queued"
    BUILDING = "Building"
    CUSTOMIZING = "Customizing"
    VALIDATING = "Validating"
    DISTRIBUTING = "Distributing"

class SharedImageStorageAccountType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Storage account type to be used to store the shared image. Omit to use the default
    (Standard_LRS).
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_ZRS = "Standard_ZRS"
