# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class EmailAttachmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of attachment file.
    """

    AVI = "avi"
    BMP = "bmp"
    DOC = "doc"
    DOCM = "docm"
    DOCX = "docx"
    GIF = "gif"
    JPEG = "jpeg"
    MP3 = "mp3"
    ONE = "one"
    PDF = "pdf"
    PNG = "png"
    PPSM = "ppsm"
    PPSX = "ppsx"
    PPT = "ppt"
    PPTM = "pptm"
    PPTX = "pptx"
    PUB = "pub"
    RPMSG = "rpmsg"
    RTF = "rtf"
    TIF = "tif"
    TXT = "txt"
    VSD = "vsd"
    WAV = "wav"
    WMA = "wma"
    XLS = "xls"
    XLSB = "xlsb"
    XLSM = "xlsm"
    XLSX = "xlsx"

class EmailImportance(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The importance type for the email.
    """

    HIGH = "high"
    NORMAL = "normal"
    LOW = "low"

class SendStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type indicating the status of a request.
    """

    #: The message has passed basic validations and has been queued to be processed further.
    QUEUED = "queued"
    #: The message has been processed and is now out for delivery.
    OUT_FOR_DELIVERY = "outForDelivery"
    #: The message could not be processed and was dropped.
    DROPPED = "dropped"
