# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServiceResourceDescription(Model):
    """Describes a service fabric service resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. The Operating system type required by the code
     in service. Possible values include: 'Linux', 'Windows'
    :type os_type: str or ~azure.servicefabric.models.OperatingSystemTypes
    :param code_packages: Required. Describes the set of code packages that
     forms the service. A code package describes the container and the
     properties for running it. All the code packages are started together on
     the same host and share the same context (network, process etc.).
    :type code_packages:
     list[~azure.servicefabric.models.ContainerCodePackageProperties]
    :param network_refs: The names of the private networks that this service
     needs to be part of.
    :type network_refs: list[~azure.servicefabric.models.NetworkRef]
    :param diagnostics: Reference to sinks in DiagnosticsDescription.
    :type diagnostics: ~azure.servicefabric.models.DiagnosticsRef
    :param description: User readable description of the service.
    :type description: str
    :param replica_count: The number of replicas of the service to create.
     Defaults to 1 if not specified.
    :type replica_count: int
    :param health_state: The health state of a Service Fabric entity such as
     Cluster, Node, Application, Service, Partition, Replica etc. Possible
     values include: 'Invalid', 'Ok', 'Warning', 'Error', 'Unknown'
    :type health_state: str or ~azure.servicefabric.models.HealthState
    :ivar status: Represents the status of the service. Possible values
     include: 'Unknown', 'Active', 'Upgrading', 'Deleting', 'Creating',
     'Failed'
    :vartype status: str or ~azure.servicefabric.models.ServiceResourceStatus
    :param name: Required. Service resource name.
    :type name: str
    """

    _validation = {
        'os_type': {'required': True},
        'code_packages': {'required': True},
        'status': {'readonly': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'code_packages': {'key': 'properties.codePackages', 'type': '[ContainerCodePackageProperties]'},
        'network_refs': {'key': 'properties.networkRefs', 'type': '[NetworkRef]'},
        'diagnostics': {'key': 'properties.diagnostics', 'type': 'DiagnosticsRef'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'replica_count': {'key': 'properties.replicaCount', 'type': 'int'},
        'health_state': {'key': 'properties.healthState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, os_type, code_packages, name: str, network_refs=None, diagnostics=None, description: str=None, replica_count: int=None, health_state=None, **kwargs) -> None:
        super(ServiceResourceDescription, self).__init__(**kwargs)
        self.os_type = os_type
        self.code_packages = code_packages
        self.network_refs = network_refs
        self.diagnostics = diagnostics
        self.description = description
        self.replica_count = replica_count
        self.health_state = health_state
        self.status = None
        self.name = name
