# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .entity_health_state_py3 import EntityHealthState


class NodeHealthState(EntityHealthState):
    """Represents the health state of a node, which contains the node identifier
    and its aggregated health state.

    :param aggregated_health_state: The health state of a Service Fabric
     entity such as Cluster, Node, Application, Service, Partition, Replica
     etc. Possible values include: 'Invalid', 'Ok', 'Warning', 'Error',
     'Unknown'
    :type aggregated_health_state: str or
     ~azure.servicefabric.models.HealthState
    :param name: The name of a Service Fabric node.
    :type name: str
    :param id: An internal ID used by Service Fabric to uniquely identify a
     node. Node Id is deterministically generated from node name.
    :type id: ~azure.servicefabric.models.NodeId
    """

    _attribute_map = {
        'aggregated_health_state': {'key': 'AggregatedHealthState', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'id': {'key': 'Id', 'type': 'NodeId'},
    }

    def __init__(self, *, aggregated_health_state=None, name: str=None, id=None, **kwargs) -> None:
        super(NodeHealthState, self).__init__(aggregated_health_state=aggregated_health_state, **kwargs)
        self.name = name
        self.id = id
