# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ChaosParametersDictionaryItem(Model):
    """Defines an item in ChaosParametersDictionary of the Chaos Schedule.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. The key identifying the Chaos Parameter in the
     dictionary. This key is referenced by Chaos Schedule Jobs.
    :type key: str
    :param value: Required. Defines all the parameters to configure a Chaos
     run.
    :type value: ~azure.servicefabric.models.ChaosParameters
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'ChaosParameters'},
    }

    def __init__(self, **kwargs):
        super(ChaosParametersDictionaryItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)
