# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource_py3 import ProxyOnlyResource


class SwiftVirtualNetwork(ProxyOnlyResource):
    """Swift Virtual Network Contract. This is used to enable the new Swift way of
    doing virtual network integration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param subnet_resource_id: The Virtual Network subnet's resource ID. This
     is the subnet that this Web App will join. This subnet must have a
     delegation to Microsoft.Web/serverFarms defined first.
    :type subnet_resource_id: str
    :param swift_supported: A flag that specifies if the scale unit this Web
     App is on supports Swift integration.
    :type swift_supported: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet_resource_id': {'key': 'properties.subnetResourceId', 'type': 'str'},
        'swift_supported': {'key': 'properties.swiftSupported', 'type': 'bool'},
    }

    def __init__(self, *, kind: str=None, subnet_resource_id: str=None, swift_supported: bool=None, **kwargs) -> None:
        super(SwiftVirtualNetwork, self).__init__(kind=kind, **kwargs)
        self.subnet_resource_id = subnet_resource_id
        self.swift_supported = swift_supported
