# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MetricSpecification(Model):
    """Definition of a single resource metric.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param display_description:
    :type display_description: str
    :param unit:
    :type unit: str
    :param aggregation_type:
    :type aggregation_type: str
    :param supports_instance_level_aggregation:
    :type supports_instance_level_aggregation: bool
    :param enable_regional_mdm_account:
    :type enable_regional_mdm_account: bool
    :param source_mdm_account:
    :type source_mdm_account: str
    :param source_mdm_namespace:
    :type source_mdm_namespace: str
    :param metric_filter_pattern:
    :type metric_filter_pattern: str
    :param fill_gap_with_zero:
    :type fill_gap_with_zero: bool
    :param is_internal:
    :type is_internal: bool
    :param dimensions:
    :type dimensions: list[~azure.mgmt.web.models.Dimension]
    :param category:
    :type category: str
    :param availabilities:
    :type availabilities: list[~azure.mgmt.web.models.MetricAvailability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'category': {'key': 'category', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[MetricAvailability]'},
    }

    def __init__(self, **kwargs):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.supports_instance_level_aggregation = kwargs.get('supports_instance_level_aggregation', None)
        self.enable_regional_mdm_account = kwargs.get('enable_regional_mdm_account', None)
        self.source_mdm_account = kwargs.get('source_mdm_account', None)
        self.source_mdm_namespace = kwargs.get('source_mdm_namespace', None)
        self.metric_filter_pattern = kwargs.get('metric_filter_pattern', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.is_internal = kwargs.get('is_internal', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.category = kwargs.get('category', None)
        self.availabilities = kwargs.get('availabilities', None)
