# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .operation_status_extended_info import OperationStatusExtendedInfo


class OperationStatusJobsExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for list of jobs.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param job_ids: IDs of the jobs created for the protected item.
    :type job_ids: list[str]
    :param failed_jobs_error: Stores all the failed jobs along with the
     corresponding error codes.
    :type failed_jobs_error: dict[str, str]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'job_ids': {'key': 'jobIds', 'type': '[str]'},
        'failed_jobs_error': {'key': 'failedJobsError', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(OperationStatusJobsExtendedInfo, self).__init__(**kwargs)
        self.job_ids = kwargs.get('job_ids', None)
        self.failed_jobs_error = kwargs.get('failed_jobs_error', None)
        self.object_type = 'OperationStatusJobsExtendedInfo'
