# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationGatewayConnectionDraining(Model):
    """Connection draining allows open connections to a backend server to be
    active for a specified time after the backend server got removed from the
    configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether connection draining is enabled or not.
    :type enabled: bool
    :param drain_timeout_in_sec: Required. The number of seconds connection
     draining is active. Acceptable values are from 1 second to 3600 seconds.
    :type drain_timeout_in_sec: int
    """

    _validation = {
        'enabled': {'required': True},
        'drain_timeout_in_sec': {'required': True, 'maximum': 3600, 'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'drain_timeout_in_sec': {'key': 'drainTimeoutInSec', 'type': 'int'},
    }

    def __init__(self, *, enabled: bool, drain_timeout_in_sec: int, **kwargs) -> None:
        super(ApplicationGatewayConnectionDraining, self).__init__(**kwargs)
        self.enabled = enabled
        self.drain_timeout_in_sec = drain_timeout_in_sec
