# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationGatewayWebApplicationFirewallConfiguration(Model):
    """Application gateway web application firewall configuration.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Whether the web application firewall is enabled.
    :type enabled: bool
    :param firewall_mode: Web application firewall mode. Possible values are:
     'Detection' and 'Prevention'. Possible values include: 'Detection',
     'Prevention'
    :type firewall_mode: str or
     ~azure.mgmt.network.v2016_09_01.models.ApplicationGatewayFirewallMode
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'firewall_mode': {'key': 'firewallMode', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayWebApplicationFirewallConfiguration, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.firewall_mode = kwargs.get('firewall_mode', None)
