# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Metric(Model):
    """The result data of a query.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. the metric Id.
    :type id: str
    :param type: Required. the resource type of the metric resource.
    :type type: str
    :param name: Required. the name and the display name of the metric, i.e.
     it is localizable string.
    :type name: ~azure.mgmt.monitor.models.LocalizableString
    :param unit: Required. the unit of the metric. Possible values include:
     'Count', 'Bytes', 'Seconds', 'CountPerSecond', 'BytesPerSecond',
     'Percent', 'MilliSeconds', 'ByteSeconds', 'Unspecified'
    :type unit: str or ~azure.mgmt.monitor.models.Unit
    :param timeseries: Required. the time series returned when a data query is
     performed.
    :type timeseries: list[~azure.mgmt.monitor.models.TimeSeriesElement]
    """

    _validation = {
        'id': {'required': True},
        'type': {'required': True},
        'name': {'required': True},
        'unit': {'required': True},
        'timeseries': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'unit': {'key': 'unit', 'type': 'Unit'},
        'timeseries': {'key': 'timeseries', 'type': '[TimeSeriesElement]'},
    }

    def __init__(self, **kwargs):
        super(Metric, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.unit = kwargs.get('unit', None)
        self.timeseries = kwargs.get('timeseries', None)
