# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationGetHttpsEndpoint(Model):
    """Gets the application HTTP endpoints.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, str]
    :param access_modes: The list of access modes for the application.
    :type access_modes: list[str]
    :param location: The location of the endpoint.
    :type location: str
    :param destination_port: The destination port to connect to.
    :type destination_port: int
    :param public_port: The public port to connect to.
    :type public_port: int
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{str}'},
        'access_modes': {'key': 'accessModes', 'type': '[str]'},
        'location': {'key': 'location', 'type': 'str'},
        'destination_port': {'key': 'destinationPort', 'type': 'int'},
        'public_port': {'key': 'publicPort', 'type': 'int'},
    }

    def __init__(self, *, additional_properties=None, access_modes=None, location: str=None, destination_port: int=None, public_port: int=None, **kwargs) -> None:
        super(ApplicationGetHttpsEndpoint, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.access_modes = access_modes
        self.location = location
        self.destination_port = destination_port
        self.public_port = public_port
