# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NameAvailabilityResponse(Model):
    """Indicates whether a proposed resource name is available.

    :param name_available: If true, the name is valid and available. If false,
     'reason' describes why not.
    :type name_available: bool
    :param reason: The reason why the name is not available, if nameAvailable
     is false. Possible values include: 'AlreadyExists', 'Invalid'
    :type reason: str or
     ~azure.mgmt.datamigration.models.NameCheckFailureReason
    :param message: The localized reason why the name is not available, if
     nameAvailable is false
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, name_available: bool=None, reason=None, message: str=None, **kwargs) -> None:
        super(NameAvailabilityResponse, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message
