# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ManualScaleSettings(Model):
    """Manual scale settings for the cluster.

    All required parameters must be populated in order to send to Azure.

    :param target_node_count: Required. The desired number of compute nodes in
     the Cluster. Default is 0. If autoScaleSettings are not specified, then
     the Cluster starts with this target. Default value: 0 .
    :type target_node_count: int
    :param node_deallocation_option: Determines what to do with the job(s)
     running on compute node if the Cluster size is decreasing. The default
     value is requeue. Possible values include: 'requeue', 'terminate',
     'waitforjobcompletion'. Default value: "requeue" .
    :type node_deallocation_option: str or
     ~azure.mgmt.batchai.models.DeallocationOption
    """

    _validation = {
        'target_node_count': {'required': True},
    }

    _attribute_map = {
        'target_node_count': {'key': 'targetNodeCount', 'type': 'int'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'str'},
    }

    def __init__(self, *, target_node_count: int=0, node_deallocation_option="requeue", **kwargs) -> None:
        super(ManualScaleSettings, self).__init__(**kwargs)
        self.target_node_count = target_node_count
        self.node_deallocation_option = node_deallocation_option
