# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ScaleSettings(Model):
    """Scale settings for the pool.

    Defines the desired size of the pool. This can either be 'fixedScale' where
    the requested targetDedicatedNodes is specified, or 'autoScale' which
    defines a formula which is periodically reevaluated. If this property is
    not specified, the pool will have a fixed scale with 0
    targetDedicatedNodes.

    :param fixed_scale: Fixed scale settings for the pool. This property and
     autoScale are mutually exclusive and one of the properties must be
     specified.
    :type fixed_scale: ~azure.mgmt.batch.models.FixedScaleSettings
    :param auto_scale: AutoScale settings for the pool. This property and
     fixedScale are mutually exclusive and one of the properties must be
     specified.
    :type auto_scale: ~azure.mgmt.batch.models.AutoScaleSettings
    """

    _attribute_map = {
        'fixed_scale': {'key': 'fixedScale', 'type': 'FixedScaleSettings'},
        'auto_scale': {'key': 'autoScale', 'type': 'AutoScaleSettings'},
    }

    def __init__(self, fixed_scale=None, auto_scale=None):
        super(ScaleSettings, self).__init__()
        self.fixed_scale = fixed_scale
        self.auto_scale = auto_scale
