# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .response import Response


class ImageInsights(Response):
    """The top-level object that the response includes when an image insights
    request succeeds. For information about requesting image insights, see the
    [insightsToken](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#insightstoken)
    query parameter. The modules query parameter affects the fields that Bing
    includes in the response. If you set
    [modules](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#modulesrequested)
    to only Caption, then this object includes only the imageCaption field.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar image_insights_token: A token that you use in a subsequent call to
     the Image Search API to get more information about the image. For
     information about using this token, see the insightsToken query parameter.
     This token has the same usage as the token in the Image object.
    :vartype image_insights_token: str
    :ivar best_representative_query: The query term that best represents the
     image. Clicking the link in the Query object, takes the user to a webpage
     with more pictures of the image.
    :vartype best_representative_query:
     ~azure.cognitiveservices.search.imagesearch.models.Query
    :ivar image_caption: The caption to use for the image.
    :vartype image_caption:
     ~azure.cognitiveservices.search.imagesearch.models.ImageInsightsImageCaption
    :ivar related_collections: A list of links to webpages that contain
     related images.
    :vartype related_collections:
     ~azure.cognitiveservices.search.imagesearch.models.RelatedCollectionsModule
    :ivar pages_including: A list of webpages that contain the image. To
     access the webpage, use the URL in the image's hostPageUrl field.
    :vartype pages_including:
     ~azure.cognitiveservices.search.imagesearch.models.ImagesModule
    :ivar shopping_sources: A list of merchants that offer items related to
     the image. For example, if the image is of an apple pie, the list contains
     merchants that are selling apple pies.
    :vartype shopping_sources:
     ~azure.cognitiveservices.search.imagesearch.models.AggregateOffer
    :ivar related_searches: A list of related queries made by others.
    :vartype related_searches:
     ~azure.cognitiveservices.search.imagesearch.models.RelatedSearchesModule
    :ivar recipes: A list of recipes related to the image. For example, if the
     image is of an apple pie, the list contains recipes for making an apple
     pie.
    :vartype recipes:
     ~azure.cognitiveservices.search.imagesearch.models.RecipesModule
    :ivar visually_similar_images: A list of images that are visually similar
     to the original image. For example, if the specified image is of a sunset
     over a body of water, the list of similar images are of a sunset over a
     body of water. If the specified image is of a person, similar images might
     be of the same person or they might be of persons dressed similarly or in
     a similar setting. The criteria for similarity continues to evolve.
    :vartype visually_similar_images:
     ~azure.cognitiveservices.search.imagesearch.models.ImagesModule
    :ivar visually_similar_products: A list of images that contain products
     that are visually similar to products found in the original image. For
     example, if the specified image contains a dress, the list of similar
     images contain a dress. The image provides summary information about
     offers that Bing found online for the product.
    :vartype visually_similar_products:
     ~azure.cognitiveservices.search.imagesearch.models.ImagesModule
    :ivar recognized_entity_groups: A list of groups that contain images of
     entities that match the entity found in the specified image. For example,
     the response might include images from the general celebrity group if the
     entity was recognized in that group.
    :vartype recognized_entity_groups:
     ~azure.cognitiveservices.search.imagesearch.models.RecognizedEntitiesModule
    :ivar image_tags: A list of characteristics of the content found in the
     image. For example, if the image is of a person, the tags might indicate
     the person's gender and the type of clothes they're wearing.
    :vartype image_tags:
     ~azure.cognitiveservices.search.imagesearch.models.ImageTagsModule
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'image_insights_token': {'readonly': True},
        'best_representative_query': {'readonly': True},
        'image_caption': {'readonly': True},
        'related_collections': {'readonly': True},
        'pages_including': {'readonly': True},
        'shopping_sources': {'readonly': True},
        'related_searches': {'readonly': True},
        'recipes': {'readonly': True},
        'visually_similar_images': {'readonly': True},
        'visually_similar_products': {'readonly': True},
        'recognized_entity_groups': {'readonly': True},
        'image_tags': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'image_insights_token': {'key': 'imageInsightsToken', 'type': 'str'},
        'best_representative_query': {'key': 'bestRepresentativeQuery', 'type': 'Query'},
        'image_caption': {'key': 'imageCaption', 'type': 'ImageInsightsImageCaption'},
        'related_collections': {'key': 'relatedCollections', 'type': 'RelatedCollectionsModule'},
        'pages_including': {'key': 'pagesIncluding', 'type': 'ImagesModule'},
        'shopping_sources': {'key': 'shoppingSources', 'type': 'AggregateOffer'},
        'related_searches': {'key': 'relatedSearches', 'type': 'RelatedSearchesModule'},
        'recipes': {'key': 'recipes', 'type': 'RecipesModule'},
        'visually_similar_images': {'key': 'visuallySimilarImages', 'type': 'ImagesModule'},
        'visually_similar_products': {'key': 'visuallySimilarProducts', 'type': 'ImagesModule'},
        'recognized_entity_groups': {'key': 'recognizedEntityGroups', 'type': 'RecognizedEntitiesModule'},
        'image_tags': {'key': 'imageTags', 'type': 'ImageTagsModule'},
    }

    def __init__(self, **kwargs) -> None:
        super(ImageInsights, self).__init__(**kwargs)
        self.image_insights_token = None
        self.best_representative_query = None
        self.image_caption = None
        self.related_collections = None
        self.pages_including = None
        self.shopping_sources = None
        self.related_searches = None
        self.recipes = None
        self.visually_similar_images = None
        self.visually_similar_products = None
        self.recognized_entity_groups = None
        self.image_tags = None
        self._type = 'ImageInsights'
