# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LuisResult(Model):
    """Prediction, based on the input query, containing intent(s) and entities.

    :param query: The input utterance that was analized.
    :type query: str
    :param altered_query: The corrected utterance (when spell checking was
     enabled).
    :type altered_query: str
    :param top_scoring_intent:
    :type top_scoring_intent:
     ~azure.cognitiveservices.language.luis.runtime.models.IntentModel
    :param intents: All the intents (and their score) that were detected from
     utterance.
    :type intents:
     list[~azure.cognitiveservices.language.luis.runtime.models.IntentModel]
    :param entities: The entities extracted from the utterance.
    :type entities:
     list[~azure.cognitiveservices.language.luis.runtime.models.EntityModel]
    :param composite_entities: The composite entities extracted from the
     utterance.
    :type composite_entities:
     list[~azure.cognitiveservices.language.luis.runtime.models.CompositeEntityModel]
    :param sentiment_analysis:
    :type sentiment_analysis:
     ~azure.cognitiveservices.language.luis.runtime.models.Sentiment
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'altered_query': {'key': 'alteredQuery', 'type': 'str'},
        'top_scoring_intent': {'key': 'topScoringIntent', 'type': 'IntentModel'},
        'intents': {'key': 'intents', 'type': '[IntentModel]'},
        'entities': {'key': 'entities', 'type': '[EntityModel]'},
        'composite_entities': {'key': 'compositeEntities', 'type': '[CompositeEntityModel]'},
        'sentiment_analysis': {'key': 'sentimentAnalysis', 'type': 'Sentiment'},
    }

    def __init__(self, *, query: str=None, altered_query: str=None, top_scoring_intent=None, intents=None, entities=None, composite_entities=None, sentiment_analysis=None, **kwargs) -> None:
        super(LuisResult, self).__init__(**kwargs)
        self.query = query
        self.altered_query = altered_query
        self.top_scoring_intent = top_scoring_intent
        self.intents = intents
        self.entities = entities
        self.composite_entities = composite_entities
        self.sentiment_analysis = sentiment_analysis
