########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Set/Strobe.py,v 1.2 2004/09/23 20:53:32 mbrown Exp $
"""
Implementation of '4ss set strobe' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command adds an XSLT Stylesheet resource in a \
4Suite repository to a list of stylesheets that will be automatically \
executed against an empty source document at regular intervals."""

import sys

from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import AclConstants, ResourceTypes


def Run(options, args):
    commit = False
    repo = CommandUtil.GetRepository(options, '4ss.set.strobe')
    if repo is not None:
        try:
            path = repo.fetchResource(args['path'])
            res = repo.fetchResource(path)
            if not user.isResourceType(ResourceTypes.ResourceType.XSLT_DOCUMENT):
                raise TypeError(path + "is not an XSLT Document")
            repo.AddXsltStrobe(path)
            commit = True
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('strobe',
                          'In a repository, flag a stylesheet to be executed at regular intervals',
                          '/repo/path/to/cron.xslt',
                          __doc__,
                          function=Run,
                          arguments=[Arguments.RequiredArgument('path',
                                                                'path of stylesheet to set for the strobe',
                                                                str),
                                     ],
                          options=Options.Options([
                                                   ]),
                          fileName=__file__,
                          )
    return cmd
