import sha, time

import test_helper

from Ft.Server.Common import ResourceTypes, AclConstants, Schema

def test_create(tester):


    tester.startTest("Create User")

    #Create Raw File
    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.createUser('user1','user1')

    tester.compare(ResourceTypes.ResourceType.USER,uRoot.hasResource('user1'))
    tester.compare(ResourceTypes.ResourceType.USER,repo.hasResource(u1.getAbsolutePath()))
    tester.compare(u1,uRoot.fetchResource('user1'))
    tester.compare('user1',u1.getPassword())
    tester.compare(ResourceTypes.ResourceType.USER,u1.getResourceType())
    tester.compare(1,u1.isResourceType(ResourceTypes.ResourceType.USER))
    tester.compare(1,u1.isResourceType(ResourceTypes.ResourceType.XML_DOCUMENT))
    tester.compare(0,u1.isResourceType(ResourceTypes.ResourceType.CONTAINER))


    dMd = u1.getMetaDataResource().getContent()
    dContent = u1.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     u1.getPath().name,
                                     ResourceTypes.ResourceType.USER,
                                     [AclConstants.READ_ACCESS,
                                      AclConstants.WRITE_ACCESS,
                                      AclConstants.CHANGE_PERMISSIONS_ACCESS,
                                      AclConstants.CHANGE_OWNER_ACCESS,
                                      AclConstants.EXECUTE_ACCESS,
                                      AclConstants.DELETE_ACCESS,
                                      AclConstants.WRITE_USER_MODEL_ACCESS,
                                      ],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     )

    test_helper.TestUserRdf(tester,
                            repo,
                            u1.getAbsolutePath(),
                            len(dContent),
                            tester.test_data['userName'],
                            cd,
                            md,
                            'text/xml',
                            Schema.NULL_DOCDEF,
                            'user1')

    
    repo.txCommit()


    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    tester.compare(uRoot,u1.getParent())
    repo.txRollback()

    tester.testDone()
    return



def test_access(tester):

    tester.startTest("User Access")

    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    tester.compare(uRoot,u1.getParent())
    tester.compare('text/xml',u1.getImt())
    u1.getContent()
    #Just call, don't test
    u1.getCreationDate()
    u1.getLastModifiedDate()
    repo.txRollback()
    
    tester.testDone()


    tester.startTest("Get all User Names")

    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    uNames = repo.getAllUserNames()
    tester.compare(1,len(uNames) > 1)
    tester.compareIn(uNames,'user1')
    repo.txRollback()
    
    tester.testDone()



def test_modify(tester):

    tester.startTest("User Modification")

    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    lmd = u1.getLastModifiedDate()
    time.sleep(1)
    pw = sha.new('newpassword').hexdigest()
    u1.setPassword(pw)
    tester.compare(pw,u1.getPassword())
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    tester.compare(pw,u1.getPassword())
    tester.compare(1,u1.getLastModifiedDate() > lmd)
    repo.txRollback()
   
    tester.testDone()

    tester.startTest("Modify not as super-user")
    repo = test_helper.GetRepo(tester,'user1','newpassword')
    u1 = repo.fetchResource('/test/user1')
    u1.setPassword("New Password")
    repo.txRollback()

    tester.testDone()


def test_user_data(tester):

    tester.startTest("User Data")

    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')

    ud = u1.getUserData()
    tester.compare(0,len(ud.keys()))

    ud['test']='foo'
    u1.setUserData(ud)

    ud = u1.getUserData()
    tester.compare(1,len(ud.keys()))
    tester.compare(1,ud.has_key('test'))
    tester.compare('foo',ud['test'])
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')
    ud = u1.getUserData()
    tester.compare(1,len(ud.keys()))
    tester.compare(1,ud.has_key('test'))
    tester.compare('foo',ud['test'])
    repo.txRollback()

    tester.testDone()

    tester.startTest("User Dictionary interface")
    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.fetchResource('user1')

    tester.compare('foo',u1['test'])
    u1['test2'] = 'foo2'
    tester.compare('foo2',u1['test2'])
    tester.compare(1,u1.has_key('test2'))
    tester.compare('foo2',u1.get('test2'))
    tester.compare(None,u1.get('test3'))

    itms =  u1.items()
    tester.compare(2,len(itms))
    tester.compare(2,len(u1.keys()))
    tester.compare(2,len(u1.values()))

    del u1['test2']
    tester.compare(0,u1.has_key('test2'))
    

    repo.txRollback()
    tester.testDone()


def test_delete(tester):

    tester.startTest("Delete User")
    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    uPath = uRoot.fetchResource('user1').getPath()
    uRoot.deleteResource('user1')
    tester.compare(0,uRoot.hasResource('user1'))
    tester.compare(0,len(repo.getModel().complete(uPath.absolutePath,None,None)))
    repo.txCommit()

    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    tester.compare(0,uRoot.hasResource('user1'))
    tester.compare(0,len(repo.getModel().complete(uPath.absolutePath,None,None)))
    repo.txRollback()

    tester.testDone()

def test_xml_interfaces(tester):

    tester.startTest("User to DOM")
    repo = test_helper.GetRepo(tester)
    uRoot = repo.fetchResource('/test')
    u1 = uRoot.createUser('user1','user1')

    dom =  u1.asDom()
    tester.compare('User',dom.documentElement.localName)
    repo.txRollback()
    tester.testDone()




def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()


def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_access(tester)
    test_modify(tester)
    test_user_data(tester)
    test_delete(tester)
    test_xml_interfaces(tester)


