

from Ft.Server.Common import ResourceTypes, ValidationInfo, Schema

import test_helper

from Ft.Server.Server import FtServerServerException, Error

from Ft.Server import FTSERVER_NAMESPACE

from Ft.Xml.XLink import XLINK_NAMESPACE

def test_create(tester):


    tester.startTest("Create command Document")

    #Create XML Document
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.createDocument('command',str(COMMAND1),forcedType=ResourceTypes.ResourceType.COMMAND)


    dMd = doc.getMetaDataResource().getContent()
    dContent = doc.getContent()

    cd,md = test_helper.TestMetaData(tester,
                                     dMd,
                                     'command',
                                     ResourceTypes.ResourceType.COMMAND,
                                     [],
                                     tester.test_data['userName'],
                                     'text/xml',
                                     str(len(dContent)),
                                     [],
                                     )

    tester.compare(COMMAND1,dContent)

    test_helper.TestCommandRdf(tester,
                               repo,
                               '/test/command',
                               len(dContent),
                               tester.test_data['userName'],
                               cd,
                               md,
                               Schema.NULL_DOCDEF,
                               'foo',
                               ['bar'])




    repo.txCommit()

    tester.testDone()
    return



def cleanup(tester):

    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        repo.deleteResource('/test')
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()



COMMAND1="""<ftss:Command xmlns:ftss="%s" xmlns:dc="%s" xmlns:xlink="%s" name='foo'>
  <dc:Description>This is a test command</dc:Description>
  <ftss:Example>foo --o=1</ftss:Example>
  <ftss:VerboseDescription>This is a very verbose description</ftss:VerboseDescription>
  <ftss:Options>
    <ftss:Option short-name='s' long-name='sample'>
      <dc:Description>A option</dc:Description>
      <ftss:SubOptions>
        <dc:Description>A sub option</dc:Description>
        <ftss:Option short-name='p' long-name='people'/>
      </ftss:SubOptions>
    </ftss:Option>
    <ftss:TypedOption short-name='s' long-name='sample'>
      <dc:Description>A typed option</dc:Description>
      <ftss:Allowed>1</ftss:Allowed>
    </ftss:TypedOption>
    <ftss:ExclusiveOption>
      <dc:Description>A exclusive option</dc:Description>
      <ftss:Option short-name='q' long-name='quite'/>
    </ftss:ExclusiveOption>
  </ftss:Options>
  <ftss:Arguments>
    <ftss:Argument name='foo' requirements='1'>
      <dc:Description>An argument</dc:Description>
    </ftss:Argument>
  </ftss:Arguments>
  <ftss:SubCommands>
    <ftss:CommandReference xlink:type="simple" xlink:href="bar" xlink:actuate="onLoad" xlink:show="embed"/>
  </ftss:SubCommands>
</ftss:Command>
""" % (FTSERVER_NAMESPACE,Schema.DC, XLINK_NAMESPACE)




def Test(tester):

    cleanup(tester)
    test_create(tester)


