__revision__ = "$Id: __init__.py,v 1.9 2003/01/17 10:07:32 jkloth Exp $"

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)
    
    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = ['test_prime']
    RemoveTests(files, ignored_files)

    ordered_files = ['test_create_container',
                     'test_fetch_container',
                     'test_delete',
                     'test_create_raw_file',
                     'test_fetch_raw_file',
                     'test_update_raw_file',
                     'test_create_document',
                     'test_fetch_document',
                     'test_update_document',
                     'test_install',
                     'test_export',
                     ]
    SortTests(files, ordered_files)

    ignored_dirs = []
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = []
    SortTests(dirs, ordered_dirs)

    return (dirs, files)

CoverageModule = 'Ft.Server.Client.Commands'
