from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
import sys, cStringIO

def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Commands')
    
    test.startTest('Syntax')
    from Ft.Rdf.Inference import InferenceEngine
    from Ft.Rdf.Inference import Command
    from Ft.Rdf.Inference import Common
    test.testDone()

    test.startTest('Stop')
    c = Command.StopCommand()

    infeng = CreateInfEng()

    context = Common.Context()
    context.skolemVariables = {}
    c.execute(infeng,context)

    test.compare(InferenceEngine.InferenceEngine.STOPPED, infeng.state)
    test.testDone()

    test.startTest('Fire')
    c = Command.FireCommand()

    infeng = CreateInfEng()

    context = Common.Context()
    context.skolemVariables = {}
    c.execute(infeng,context)

    test.compare(InferenceEngine.InferenceEngine.READY, infeng.state)
    test.testDone()

    test.startTest('Message')
    s = Common.StringLiteralArgument("arg1","Foo")
    c = Command.MessageCommand([s])

    infeng = CreateInfEng()

    context = Common.Context()
    context.skolemVariables = {}
    infeng.outStream = cStringIO.StringIO()
    c.execute(infeng,context)
    result = infeng.outStream.getvalue()
    expected = "**Start Ril Message**\n"
    expected = expected + "['Foo']\n"
    expected = expected + "**End Ril Message**\n"
    test.compare(expected, result)
    test.testDone()

    test.groupDone()


if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)
