from Ft.Ods import Database
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")
def Test(tester):


    tester.startGroup("Test Interface Creation %s Driver" % tester.test_data['driver'])

    tester.startTest("Init DB")
    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    tester.testDone()
    db = Database.Database()
    db.open(DBNAME)

    try:
        tester.startTest("New Class with no bases")
        #Create a new class object
        tx = db.new()
        tx.begin()
        top = db.schema().resolve('ODLMetaObjects')
        short = db.schema().resolve('pk_short')
        c = top.add_class("Base",None,None)
        c.add_attribute("attr1",short)
        tx.commit()

        tester.testDone()

        tester.startTest("New Class with base")
        #Create a new class object
        tx = db.new()
        tx.begin()
        top = db.schema().resolve('ODLMetaObjects')
        short = db.schema().resolve('pk_short')
        c1 = top.resolve("Base")
        c2 = top.add_class("Derived",None,c1)
        c2.add_attribute("attr2",short)
        tx.commit()

        tester.testDone()

        tester.startTest("New Class with base and inherits")
        #Create a new class object
        tx = db.new()
        tx.begin()
        top = db.schema().resolve('ODLMetaObjects')
        short = db.schema().resolve('pk_short')
        c1 = top.resolve("Base")
        c2 = top.resolve("Derived")
        i = top.add_interface("Int",[])
        i.add_attribute("aintAtr1",short)
        c3 = top.add_class("MostDervied",[i],c2)
        c3.add_attribute("attr3",short)
        tx.commit()

        tester.testDone()

        tester.startTest("New Class with extent")
        #Create a new class object
        tx = db.new()
        tx.begin()
        top = db.schema().resolve('ODLMetaObjects')
        short = db.schema().resolve('pk_short')
        c4 = top.add_class("ExtClass",[],None)
        c4.add_attribute("attr4",short)
        c4.extents.append("extent")
        tx.commit()

        tester.testDone()

        tester.groupDone()
    finally:
        db.close()

