########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/GroupableObject.py,v 1.5 2004/12/24 22:02:35 mbrown Exp $
"""
XSLT and XPath extensions supporting the 4SS groupable object API

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Xml.XPath import Conversions

from Ns import SCORE_NS
import FtssXsltBase


def GetGroups(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)
    groups = [ group.getAbsolutePath() for group in base.getGroups() ]

    doc = context.node.rootNode
    return map(doc.createTextNode, groups)


ExtFunctions = {
    (SCORE_NS, 'get-groups'): GetGroups,
}

ExtElements = {
}
