<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY fschema "http://schemas.4suite.org/4ss">
]>
<xsl:stylesheet 
  version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:fcore="http://xmlns.4suite.org/4ss/score" 
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" 
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http" 
  xmlns:exslt="http://exslt.org/common" 
  xmlns:exslt-set="http://exslt.org/sets" 
  xmlns:exslt-math="http://exslt.org/math" 
  xmlns:exslt-functions="http://exslt.org/functions" 
  xmlns:exslt-date-time="http://exslt.org/dates-and-times" 
  xmlns:dc="&dc;" 
  xmlns:fres="&fres;" 
  xmlns:rdf="&rdf;" 
  xmlns:f="&f;" 
  xmlns:fschema="http://schemas.4suite.org/4ss" 
  xmlns:xlink='http://www.w3.org/1999/xlink'

  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">

  <xsl:output method="html"/>
  <xsl:param name="genericManage"/>
  <xsl:param name="nonXMLPath"/>
  <xsl:param name="fres:uri-path"/>
  <xsl:param name="fres:absolute-path"/>
  <xsl:param name="type"/>
  <xsl:include href="menu-includes.xslt"/>
  <xsl:include href="managerRequestProcessor.xslt"/>
  <xsl:include href="container.xslt"/>
  <xsl:variable name="action" select="string(fhttp:get-query-args()//action)"/>
  <xsl:variable name="resourcePath" select="concat('/ftss/',$type)"/>
  <xsl:variable name="resourceType" select="frdf:complete($resourcePath,'&fschema;#type',frdf:any())/Object"/>
  <xsl:variable name="displayName" select="concat('Meta Container (',$type,')')"/>
  <xsl:template match="/">
    <xsl:call-template name="menus">
      <xsl:with-param name="displayName" select="$displayName"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="body">
    <xsl:variable name="systemMetaContainer-rtf">
      <fres:Container>
        <fres:Children>
          <xsl:choose>
            <xsl:when test='$type = "servers"'>
              <xsl:call-template name="system-servers"/>
            </xsl:when>
            <xsl:when test='$type = "groups"'>
              <xsl:call-template name="system-groups"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="system-users"/>
            </xsl:otherwise>
          </xsl:choose>
        </fres:Children>
      </fres:Container>
    </xsl:variable>
    <xsl:variable name="systemMetaContainer" select="exslt:node-set($systemMetaContainer-rtf)"/>
    <xsl:for-each select="$systemMetaContainer">
      <xsl:call-template name="container-manager"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="system-servers">
    <xsl:for-each select="frdf:complete(frdf:any(),'&fschema;#type','&fschema;#server')">
      <fres:ChildReference xlink:href="{concat(./Subject,';metadata')}"/>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="system-groups">
    <xsl:for-each select="frdf:complete(frdf:any(),'&fschema;#type','&fschema;#group')">
      <fres:ChildReference xlink:href="{concat(./Subject,';metadata')}"/>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="system-users">
    <xsl:for-each select="frdf:complete(frdf:any(),'&fschema;#type','&fschema;#user')">
      <fres:ChildReference xlink:href="{concat(./Subject,';metadata')}"/>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
