########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/List/__init__.py,v 1.4 2004/08/20 21:11:01 mbrown Exp $
"""
Implementation of '4ss list' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command lists information about sets of certain \
types of resources in a 4Suite repository. A subcommand specifying \
which type of resource to list is required. See the help message for \
a subcommand for specific usage info."""

# command modules to register as subcommands
import DocDefs
import Groups
import Users

g_subCommands = [
    DocDefs,
    Groups,
    Users,
    ]


def Register():
    from Ft.Lib.CommandLine import Options, Command
    sc = map(lambda x: x.Register(), g_subCommands)
    cmd = Command.Command('list',
                          "List certain types of resources in a repository",
                          None,
                          __doc__,
                          subCommands = sc,
                          fileName = __file__,
                          )
    return cmd

