from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
from Ft.Rdf.Statement import Statement

def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Rule')
    
    test.startTest('Syntax')
    if 1:
    #try:
        from Ft.Rdf.Inference import InferenceEngine
        from Ft.Rdf.Inference import Common
        from Ft.Rdf.Inference import Predicate
        from Ft.Rdf.Inference import Assert
        from Ft.Rdf.Inference import Rule
        from Ft.Rdf.Inference import Query
    #except:
    #    test.error('Error in syntax', 1)
    test.testDone()

    #Test skolem variables
    test.startTest('Single Predicate')
    sv = Common.SkolemVariableArgument("X")
    sv1 = Common.SkolemVariableArgument("Y")
    p1 = Predicate.AndSinglePredicate("http://spam.com#foo",(sv,))
    p2 = Predicate.AndDualPredicate("http://spam.com#bar",(sv,sv1))
    a1 = Assert.SingleAssert("http://spam.com#accept",0,(sv1,))
    q1 = Query.SingleQuery("http://spam.com#accept",(sv,))

    rule = Rule.Rule("Rule 1",[p1,p2],[a1])

    infeng = CreateInfEng()

    #Assert directly to RDF
    foo = Statement('http://ogbuji.net#uche', 'http://spam.com#foo', '1')
    bar = Statement('http://ogbuji.net#uche', 'http://spam.com#bar', 'Got It')
    infeng.workspace.add([foo,bar])

    context = Common.Context()
    infeng.state = InferenceEngine.InferenceEngine.CHAINING
    rule.fire(infeng,context)
    results = q1.execute(infeng,context)
    test.testResults([('Got It', 'http://spam.com#accept', '1')],results)

    test.testDone()
    test.groupDone()



if __name__ == '__main__':
    import sys
    from Ft.Lib import TestSuite

    testmgr = TestSuite.TestSuite()
    ret_val = Test(testmgr)
    sys.exit(ret_val)

