from Ft.Lib import TestSuite
from Ft.Lib import XUpdate
from Ft.Lib import pDomlette
import xml.dom.ext
import cStringIO

#From the spec

src_1 = """\
<?xml version="1.0"?>
<addresses version="1.0">

  <address id="1">
    <fullname>Andreas Laux</fullname>
    <born day='1' month='12' year='1978'/>
    <town>Leipzig</town>
    <country>Germany</country>
  </address>

</addresses>
"""

xu_1 = """\
<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
>

  <xupdate:insert-after select="/addresses/address[1]" >

    <xupdate:element name="address">
      <xupdate:attribute name="id">2</xupdate:attribute>
      <fullname>Lars Martin</fullname>
      <born day='2' month='12' year='1974'/>
      <town>Leizig</town>
      <country>Germany</country>
    </xupdate:element>
  </xupdate:insert-after>

</xupdate:modifications>
"""

expected_1 = """<?xml version='1.0' encoding='UTF-8'?><addresses version='1.0'>

  <address id='1'>
    <fullname>Andreas Laux</fullname>
    <born day='1' month='12' year='1978'/>
    <town>Leipzig</town>
    <country>Germany</country>
  </address>

    <address id='2'>
      
      <fullname>Lars Martin</fullname>
      <born/>
      <town>Leizig</town>
      <country>Germany</country>
    </address>
  

</addresses>"""

src_2 = """\
<?xml version="1.0"?>
<addresses>
  <address>
    <town>Los Angeles</town>
  </address>
</addresses>
"""

xu_2 = """\
<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
>

  <xupdate:append select="/addresses" child="last()">
    <xupdate:element name="address">
      <town>San Francisco</town>
    </xupdate:element>
  </xupdate:append>

</xupdate:modifications>
"""

expected_2 = """<?xml version='1.0' encoding='UTF-8'?><addresses>
  <address>
    <town>Los Angeles</town>
  </address>

    <address>
      <town>San Francisco</town>
    </address>
  </addresses>"""

src_3 = """\
<?xml version="1.0"?>
<addresses>
  <address>
    <town>Los Angeles</town>
  </address>
  <address>
    <town>San Francisco</town>
  </address>
</addresses>
"""

xu_3 = """\
<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
>

  <xupdate:update select="/addresses/address[2]/town">
    New York
  </xupdate:update>

</xupdate:modifications>
"""

expected_3 = """<?xml version='1.0' encoding='UTF-8'?><addresses>
  <address>
    <town>Los Angeles</town>
  </address>
  <address>
    <town>
    New York
  </town>
  </address>
</addresses>"""

src_4 = src_3

xu_4 = """\
<?xml version="1.0"?>
<xupdate:modifications
  version="1.0"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
>

  <xupdate:remove select="/addresses/address[1]"/>

</xupdate:modifications>
"""

expected_4 = """<?xml version='1.0' encoding='UTF-8'?><addresses>
  
  <address>
    <town>San Francisco</town>
  </address>
</addresses>"""

#etc

reader = pDomlette.PyExpatReader()
xureader = XUpdate.Reader()
from Ft.Lib import TreeCompare

def Test(tester):
    processor = XUpdate.Processor()
    tester.startGroup("XUpdate")

    tester.startTest("XUpdate spec example 1")

    src = reader.fromString(src_1)
    xu = xureader.fromString(xu_1)

    processor.execute(src, xu)
    st = cStringIO.StringIO()
    
    xml.dom.ext.Print(src, stream=st)
    
    tester.compare(expected_1, st.getvalue(), msg="XUpdate/eg1",
                   func=TreeCompare.TreeCompare, diff=1)

    tester.testDone()

    tester.startTest("Append")

    src = reader.fromString(src_2)
    xu = xureader.fromString(xu_2)

    processor.execute(src, xu)
    st = cStringIO.StringIO()
    
    xml.dom.ext.Print(src, stream=st)
    
    tester.compare(expected_2, st.getvalue(), msg="XUpdate/Append",
                   func=TreeCompare.TreeCompare, diff=1)

    tester.testDone()

    tester.startTest("Update")

    src = reader.fromString(src_3)
    xu = xureader.fromString(xu_3)

    processor.execute(src, xu)
    st = cStringIO.StringIO()
    
    xml.dom.ext.Print(src, stream=st)
    
    tester.compare(expected_3, st.getvalue(), msg="XUpdate/Update",
                   func=TreeCompare.TreeCompare, diff=1)

    tester.testDone()

    tester.startTest("Remove")

    src = reader.fromString(src_4)
    xu = xureader.fromString(xu_4)

    processor.execute(src, xu)
    st = cStringIO.StringIO()
    
    xml.dom.ext.Print(src, stream=st)
    
    tester.compare(expected_4, st.getvalue(), msg="XUpdate/Remove",
                   func=TreeCompare.TreeCompare, diff=1)

    tester.testDone()
    
    tester.groupDone()


if __name__ == '__main__':
    tester = TestSuite.TestSuite(1, 1)
    Test(tester)

