########################################################################
#
# File Name: 	       Property.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Property.py.html
#
"""
Implements the Property meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import MetaObject
from Ft.Ods.MetaData import Type
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods import PersistentObject
td=PersistentObject.TupleDefinitions

#ftods_attributes = ['']

class Property(MetaObject.MetaObject):
    def __init__(self, db,data, meta_kind):
        MetaObject.MetaObject.__init__(self, db, data, meta_kind)


    def form_type(self,target,inverse=1):
        self._4ods_formRelationship('type',Type.Type,'properties','add',target,inverse)

    def drop_type(self,target,inverse=1):
        self._4ods_dropRelationship('type','properties','remove',target,inverse)

      
    def _4ods_getOdmgType(self):
        return self.type._4ods_getOdmgType()

    def _4ods_findTypePath(self,object):
        if object == self.type:
            return [self,object]
        return []




    _tupleNames = (('type',),)


    _tupleDefinitions = {'type':{td.TYPE:Constants.Types.ROBJECT,
                                 td.READONLY:1,
                                 td.RELATIONSHIP:1,
                                 },
                         }
    _localExtents = ()
