from Ft.Lib import ReaderException, PgException, PdomletteException, XIncludeException

try:
    import os, gettext
    locale_dir = os.path.split(__file__)[0]
    gettext.install('4Suite', locale_dir)
except (ImportError, AttributeError, IOError):
    def _(msg):
        return msg

PDOMLETTE = {
    PdomletteException.PICKLE_DOCUMENT_FRAGMENT: _("Cannot pickle a pDomlette document fragment node"),
    PdomletteException.PICKLE_DOCUMENT: _("Cannot pickle a pDomlette document node"),
    }

POSTGRES = {
    PgException.NO_PYGRES: _("Unable to import PyGresQL: cannot use PostgreSQL"),
    }

XINCLUDE = {
    XIncludeException.XINCLUDE_MISSING_HREF: _("An XInclude element must have an href attribute."),
    XIncludeException.CIRCULAR_INCLUDE_ERROR: _("Circular import of '%s'"),
    }

READER = {
    ReaderException.XML_PARSE_ERROR: _('XML parse error at line %d, column %d: %s'),
    ReaderException.XML_SAX_PARSE_ERROR: _('XML parse error processing "%s"%s, at line %d, column %d: %s'),
    ReaderException.XMLNS_UNKNOWN_PREFIX: _('Unknown namespace prefix parsing XML file: %s'),
    }

