# Pyntor::Image - Position an image for display
# Copyright (C) 2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *

class Image:
	def init(self, options):
		self.xpos = options["xpos"]
		self.ypos = options["ypos"]
		self.image = options["image"]

	def render(self, screen, page, globalpage):
		if self.xpos[-1] == "%":
			x = self.xpos[:-1]
			x = screen.get_width() / 100.0 * int(x)
		else:
			x = int(self.xpos)
		if self.ypos[-1] == "%":
			y = self.ypos[:-1]
			y = screen.get_height() / 100.0 * int(y)
		else:
			y = int(self.ypos)
		surface = pygame.image.load(self.image)
		screen.blit(surface, (x, y))

component = Image()

parameters = (
	("xpos", "Horizontal position of the image", None),
	("ypos", "Vertical position of the image", None),
	("image", "Image file to display", None),
)

metainfo = {
	"version": "0.2",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Image: displays an image on a specified position

Usage: 'image' -xpos <x> -ypos <y> -image <imagefile>
 Where <x> and <y> are the coordinates in pixels, and <imagefile> contains
 a pygame-displayable picture in formats such as PNG, JPEG or BMP

Display: yes

Interactivity: no
"""

