# Pyntor::Background - Display a simple background image
# Copyright (C) 2004-2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *

import re

class Background:
	def init(self, options):
		self.image = None
		self.colour = None

		self.image = options["background"]

		r_rgb = re.compile("[0-9a-f]{6}")
		m_rgb = r_rgb.match(self.image)
		if m_rgb:
			colour = self.image
			c1 = int(colour[0:2], 16)
			c2 = int(colour[2:4], 16)
			c3 = int(colour[4:6], 16)
			self.colour = (c1, c2, c3)
			self.image = None

	def render(self, screen, page, globalpage):
		if self.image:
			surface = pygame.image.load(self.image)
			screen.blit(surface, (0, 0))
		else:
			screen.fill(self.colour)

component = Background()

parameters = (
	("background", "Image file or colour to use for background", None),
)

metainfo = {
	"version": "0.2",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Background: fills the background with a colour or an image

Usage: 'background' -background <image|colour>
 Where <image> is a file containing a full-sized image, or alternatively
 a <colour> can be given in hex format (like 00ffab)

Display: yes

Interactivity: no
"""

