# PyJWT

[![travis-status-image]][travis]
[![appveyor-status-image]][appveyor]
[![pypi-version-image]][pypi]
[![coveralls-status-image]][coveralls]
[![docs-status-image]][docs]

A Python implementation of [RFC 7519][jwt-spec].
Original implementation was written by [@progrium][progrium].

## Installing

```
$ pip install PyJWT
```

## Usage

```python
>>> import jwt
>>> encoded = jwt.encode({'some': 'payload'}, 'secret', algorithm='HS256')
'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzb21lIjoicGF5bG9hZCJ9.4twFt5NiznN84AWoo1d7KO1T_yoc0Z6XOpOVswacPZg'

>>> jwt.decode(encoded, 'secret', algorithms=['HS256'])
{'some': 'payload'}
```

## Tests

You can run tests from the project root after cloning with:

```
$ python setup.py test
```

[travis-status-image]: https://secure.travis-ci.org/jpadilla/pyjwt.svg?branch=master
[travis]: http://travis-ci.org/jpadilla/pyjwt?branch=master
[appveyor-status-image]: https://ci.appveyor.com/api/projects/status/h8nt70aqtwhht39t?svg=true
[appveyor]: https://ci.appveyor.com/project/jpadilla/pyjwt
[pypi-version-image]: https://img.shields.io/pypi/v/pyjwt.svg
[pypi]: https://pypi.python.org/pypi/pyjwt
[coveralls-status-image]: https://coveralls.io/repos/jpadilla/pyjwt/badge.svg?branch=master
[coveralls]: https://coveralls.io/r/jpadilla/pyjwt?branch=master
[docs-status-image]: https://readthedocs.org/projects/pyjwt/badge/?version=latest
[docs]: http://pyjwt.readthedocs.org
[jwt-spec]: https://tools.ietf.org/html/rfc7519
[progrium]: https://github.com/progrium
