// Pspell implementation header file.
// Applications that just use the pspell library should not include 
// these files as they are subject to change.
// Pspell Modules MUST include some of the implementation files and
// spell checkers MAY include some of these files.
// If ANY of the implementation files are included you also link with
// libaspell-impl to protect you from changes in these files.

// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef PSEPLL_ERROR_IMPL__HH
#define PSEPLL_ERROR_IMPL__HH

#include "error.h"
#include "string.hh"

class PspellCanHaveErrorImpl : public PspellCanHaveError {
public:
  int          error_num_;
  PspellString error_mesg_;
  PspellErrorExtraInfo * error_extra_;

public:
  int          error_number () const {return error_num_;}
  const char * error_message() const {return error_mesg_.c_str();}
  const PspellErrorExtraInfo * error_extra_info() const {return error_extra_;}
  
  void reset_error();
  
  PspellCanHaveErrorImpl() 
    : error_num_(0), error_extra_(0) {}

  PspellCanHaveErrorImpl(const PspellCanHaveErrorImpl &) 
  {
    // do nothing
  }
  PspellCanHaveErrorImpl & operator = (const PspellCanHaveErrorImpl &) 
  {
    return *this;
  }

  PspellCanHaveErrorImpl *
  set_error(PspellCanHaveError * err)
  {
    error_num_  = err->error_number();
    error_mesg_ = err->error_message();
    //FIXME: handle setting the error_extra
    if (error_extra_ != 0) delete error_extra_;
    error_extra_ = 0;
    return this;
  }

  PspellCanHaveErrorImpl * 
  set_error(void (*fun) (int &, PspellErrorExtraInfo * &, 
			 PspellAppendableString &, 
			 const char *), 
	    const char * p1)
  {
    (*fun)(error_num_, error_extra_, error_mesg_, p1);
    return this;
  }

  PspellCanHaveErrorImpl * 
  set_error(void (*fun) (int &, PspellErrorExtraInfo * &, 
			 PspellAppendableString &, 
			 const char *, const char *), 
	    const char * p1, const char * p2)
  {
    (*fun)(error_num_, error_extra_, error_mesg_, p1, p2);
    return this;
  }

  PspellCanHaveErrorImpl * 
  set_error(void (*fun) (int &, PspellErrorExtraInfo * &, 
			 PspellAppendableString &, 
			 const char *, const char *, const char *), 
	    const char * p1, const char * p2, const char * p3)
  {
    (*fun)(error_num_, error_extra_, error_mesg_, p1, p2, p3);
    return this;
  }

  PspellCanHaveErrorImpl * 
  set_error(int num, const char * mesg) 
  {
    error_num_  = num;
    error_mesg_ = mesg;
    return this;
  }
  
  ~PspellCanHaveErrorImpl() {
    delete error_extra_;
  }

};

#endif
