/*
    GNUstepAppLauncher.h

    Interface declaration of the GNUstepAppLauncher project module for the
    ProjectManager application.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>
#import "../../ProjectModule.h"

@class NSMutableArray,
       NSMutableDictionary,
       NSTask,
       NSFileHandle,
       NSNotification,
       NSTableView,
       NSTableColumn;

@protocol GNUstepAppLauncherDelegate;

extern NSString * const GNUstepAppLauncherProjectWillLaunchNotification;
extern NSString * const GNUstepAppLauncherProjectDidLaunchNotification;
extern NSString * const GNUstepAppLauncherProjectDidFailToLaunchNotification;
extern NSString * const GNUstepAppLauncherProjectDidTerminateNotification;

typedef enum {
  GNUstepAppLauncherReadyState,
  GNUstepAppLauncherDelayedLaunchState,
  GNUstepAppLauncherLaunchedState
} GNUstepAppLauncherState;

@interface GNUstepAppLauncher : NSObject <ProjectModule>
{
  ProjectDocument * document;

  id bogusWindow, view;

  id stderr;
  id stdout;
  id stdin;
  id workingDirectory;
  id workingDirectoryButton;
  id targets;
  // holds the name of the target which was chose when `Launch' was hit
  NSString * target;

  id args, env;
  id argsPanel, envPanel;
  // When we resign being the current project module the arguments
  // and environment panel are closed to not collide with any other
  // panels. In these ivars we store whether the panels were open
  // when the module was changed, so that later on when we again
  // become the current module we know whether we need to open them
  // open again
  BOOL argsPanelWasOpen, envPanelWasOpen;

  NSMutableArray * arguments;
  NSMutableDictionary * environment;
  NSArray * sortedEnvironmentNames;

  NSTask * task;
  NSFileHandle * stdinHandle,
               * stdoutHandle,
               * stderrHandle;

  id <GNUstepAppLauncherDelegate> delegate;     // weak reference

  GNUstepAppLauncherState launcherState;
}

- (void) appendStdoutMessage: (NSString *) aMessage;
- (void) appendStderrMessage: (NSString *) aMessage;

- (void) launch: (id) sender;
- (void) proceedWithLaunch: (BOOL) flag;

- (void) kill: (id) sender;
- (void) stopLaunch: (id) sender;

- (void) chooseWorkingDirectory: (id) sender;
- (void) showArguments: (id) sender;
- (void) showEnvironment: (id) sender;
- (void) writeStdin: (id) sender;

- (void) addArg: sender;
- (void) removeArg: sender;
- (void) moveArgUp: sender;
- (void) moveArgDown: sender;

- (void) addEnv: sender;
- (void) removeEnv: sender;

- (void) moduleChanged: (NSNotification *) notif;

// notification invoked when the task terminates
- (void) taskTerminated;

// notifications for collecting stdout/err output
- (void) readStdout;
- (void) readStderr;

// table view data source methods
- (int) numberOfRowsInTableView: (NSTableView *)aTableView;
- (id) tableView: (NSTableView *)aTableView 
objectValueForTableColumn: (NSTableColumn *)aTableColumn 
             row: (int)rowIndex;
- (void) tableView: (NSTableView *)aTableView 
    setObjectValue: (id)anObject 
    forTableColumn: (NSTableColumn *)aTableColumn
               row: (int)rowIndex;

@end
