#include "ImageView.h"
#include <Foundation/NSNotification.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSValue.h>
#include <AppKit/NSEvent.h>

@implementation ImageView 

- (void) mouseDown: (NSEvent*)event
{
   selectionStart = [self convertPoint: [event locationInWindow] fromView: nil];
}

- (void) mouseDragged: (NSEvent*)event
{
   NSSize scrollAmount = NSMakeSize(-[event deltaX], -[event deltaY]);
   
   [[NSNotificationCenter defaultCenter] postNotificationName: @"TEST"
					 object: self
					 userInfo: [NSDictionary dictionaryWithObject: [NSValue valueWithSize: scrollAmount]
								 forKey: @"UserInfoKeyScrollAmount"]];
}


- (void) mouseUp: (NSEvent*)event
{
  return;
}


@end
