#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <stdio.h>
#include <stdlib.h>
#include "Panel.h"
#include "Parts.h"
#include "Ctimer.h"
#include "Indicator.h"
#include "Time.h"
#include "xppxp.h"
#include "pixmap/panel.xpm"
#include "pixmap/button1a.xpm"
#include "pixmap/button2a.xpm"
#include "pixmap/button3a.xpm"
#include "pixmap/button4a.xpm"
#include "pixmap/button5a.xpm"
#include "pixmap/button1b.xpm"
#include "pixmap/button2b.xpm"
#include "pixmap/button3b.xpm"
#include "pixmap/button4b.xpm"
#include "pixmap/button5b.xpm"
#include "pixmap/led1a.xpm"
#include "pixmap/led2a.xpm"
#include "pixmap/led3a.xpm"
#include "pixmap/led4a.xpm"
#include "pixmap/led5a.xpm"
#include "pixmap/led1b.xpm"
#include "pixmap/led2b.xpm"
#include "pixmap/led3b.xpm"
#include "pixmap/led4b.xpm"
#include "pixmap/led5b.xpm"

static struct st_parts {
        Widget *widget;
        char *name;
        int xpos;
        int ypos;
        char *offpixmap;
        char *onpixmap;
} parts[] = {
{&led1,    "led1",     14,  9, (char *)led1a,    (char *)led1b},
{&led2,    "led2",     34,  9, (char *)led2a,    (char *)led2b},
{&led3,    "led3",     54,  9, (char *)led3a,    (char *)led3b},
{&led4,    "led4",     74,  9, (char *)led4a,    (char *)led4b},
{&button1, "button1",  10, 62, (char *)button1a, (char *)button1b},
{&button2, "button2",  32, 62, (char *)button2a, (char *)button2b},
{&button3, "button3",  64, 62, (char *)button3a, (char *)button3b},
{&button4, "button4", 152, 62, (char *)button4a, (char *)button4b},
{&button5, "button5", 174, 62, (char *)button5a, (char *)button5b},
};

void
panel_init()
{
        int i;

        base = XtVaCreateManagedWidget("base", panelWidgetClass,
                                        top, 
                                        XtNpanelPixmapData,  panel_xpm,
                                        XtNlabelPixmap,      label_pixmap,
                                        NULL);
        indc = XtVaCreateManagedWidget("indicator", indicatorWidgetClass,
                                       base, 
                                       XtNinRate,    0,
                                       XtNoutRate,   0,
                                       XtNbackground, "black",
                                       XtNx, 10,
                                       XtNy, 29,
                                       XtNborderWidth, 0,
                                       NULL);
        tdisp = XtVaCreateManagedWidget("time", timeWidgetClass,
                                       base,
                                       XtNtime,    -1,
                                       XtNbackground, "black",
                                       XtNx, 99,
                                       XtNy, 63,
                                       XtNborderWidth, 0,
                                       NULL);

        for(i=0; i<9; i++) {
                *(parts[i].widget) = XtVaCreateManagedWidget(
                            parts[i].name, partsWidgetClass, base, 
                            XtNx, parts[i].xpos,
                            XtNy, parts[i].ypos,
                            XtNonPixmapData,  parts[i].onpixmap,
                            XtNoffPixmapData, parts[i].offpixmap,
                            XtNborderWidth, 0,
                            NULL);
        }
        led5 = XtVaCreateManagedWidget(
                            "led5", ctimerWidgetClass, base,
                            XtNx, 94,
                            XtNy,  9,
                            XtNoffPixmapData,   led5a,
                            XtNonPixmapData,    led5b,
                            XtNboffPixmapData,  led1a,
                            XtNbonPixmapData,   led1b,
                            XtNborderWidth,     0,
                            NULL);
}
