#
#
#
#

proc panel:time {frame} {
    global panel_connect_time panel_idle_time

    set f [frame $frame]

    set panel_connect_time "00:00:00"
    label $f.connectTime -textvariable panel_connect_time -pady 0
    PPxP:UpdateInfoWidget $f.connectTime connect {
	set panel_connect_time [PPxP:ConnectTime]
    }
    set panel_idle_time "00:00"
    label $f.idleTime -textvariable panel_idle_time -pady 0
    PPxP:UpdateInfoWidget $f.idleTime idle {
	set panel_idle_time [PPxP:IdleTime]
    }
    label $f.connectTimeLabel -text "Connect" -pady 0
    label $f.idleTimeLabel -text "Idle" -pady 0

    grid $f.connectTimeLabel -column 0 -row 0 -sticky w
    grid $f.connectTime      -column 0 -row 1 -sticky w
    grid $f.idleTimeLabel    -column 2 -row 0 -sticky w
    grid $f.idleTime         -column 2 -row 1 -sticky w

    grid rowconfigure $f 0 -pad 0
    grid rowconfigure $f 1 -pad 0
    grid columnconfigure $f 1 -minsize 10

    return $f
}

proc panel:ind {frame} {
    global TKPPXPDIR IMAGEDIR
    set in_image [image create bitmap \
		      -file [file join $IMAGEDIR in6x6.xbm]]
    set out_image [image create bitmap \
		       -file [file join $IMAGEDIR out6x6.xbm]]

    $in_image configure -foreground white
    $out_image configure -foreground white

    Indicator $frame $in_image $out_image 2
}

proc panel:status {frame} {
    set f [frame $frame]

    label $f.dialLabel -text "Dial"
    label $f.chatLabel -text "Chat"
    label $f.authLabel -text "Auth"
    label $f.networkLabel -text "Network"

    foreach w [list $f.dialLabel $f.chatLabel $f.authLabel $f.networkLabel] {
	set acolor [option get $w activeForeground   {}]
	set dcolor [option get $w disabledForeground {}]
	lappend panel_status_table [list $w $acolor $dcolor]
    }
    panel:update_status $panel_status_table

    set id [PPxP:RegisterUpdateStatus \
		[list panel:update_status $panel_status_table]]
    bind $f <Destroy> [list PPxP:UnregisterUpdate $id]

    pack $f.dialLabel $f.chatLabel $f.authLabel $f.networkLabel -side left

    return $f
}

proc panel:update_status {table} {
    global PPxPStatus

    set i 0
    foreach l $table {
	set w [lindex $l 0]
	set a [lindex $l 1]
	set d [lindex $l 2]

	if {$PPxPStatus > $i} {
	    $w configure -foreground $a
	} else {
	    $w configure -foreground $d
	}
	incr i
    }
}

proc panel:auto {frame} {
    global panel_auto_status

    set f [button $frame]
    $f configure -borderwidth 0 -highlightthickness 0
    $f configure -command panel:auto_command

    set on_color [option get $f "onForeground" {}]
    set off_color [option get $f "offForeground" {}]
    set on_acolor [option get $f "onActiveForeground" {}]
    set off_acolor [option get $f "offActiveForeground" {}]

    $f configure -text "Auto"  -foreground $off_color
    panel:set_tooltip $f.tooltip $f {}

    PPxP:UpdateInfoWidget $f mode \
	[list panel:update_auto $f $on_color $off_color $on_acolor $off_acolor]

    return $f
}

proc panel:auto_command {} {
    global PPxP PPxPInfo

    if {$PPxPInfo(mode) == "auto"} {
	$PPxP auto off
    } else {
	$PPxP auto
    }
}

proc panel:update_auto {w on off on_a off_a} {
    global PPxPInfo

    if {$PPxPInfo(mode) == "auto"} {
	$w configure -foreground $on
	$w configure -activeforeground $on_a
    } else {
	$w configure -foreground $off
	$w configure -activeforeground $off_a
    }
}

proc panel:address {frame} {
    global PPxPVar panel_local_addr panel_remote_addr

    set f [frame $frame -bd 2 -relief sunken]

    label $f.localLabel  -text "L"
    label $f.remoteLabel -text "R"

    label $f.localAddress  -width 14 -anchor w \
	-textvariable panel_local_addr
    label $f.remoteAddress -width 14 -anchor w \
	-textvariable panel_remote_addr

    panel:set_address IP.LOCAL  panel_local_addr
    panel:set_address IP.REMOTE panel_remote_addr
    PPxP:UpdateVarWidget $f IP.LOCAL \
	{panel:set_address IP.LOCAL  panel_local_addr}
    PPxP:UpdateVarWidget $f IP.REMOTE \
	{panel:set_address IP.REMOTE panel_remote_addr}
    PPxP:UpdateInfoWidget $f netstat {$PPxP env IP}

    grid $f.localLabel   -column 0 -row 0 -sticky ew
    grid $f.remoteLabel  -column 0 -row 1 -sticky ew
    grid $f.localAddress -column 1 -row 0
    grid $f.remoteAddress -column 1 -row 1

    return $f
}

proc panel:set_address {elem varname} {
    upvar \#0 $varname var
    global PPxPVar

    set var [lindex [split $PPxPVar($elem) "/"] 0]
}

proc panel:logo {frame} {
    set f [label $frame.ppxpLabel -text "PPxP"]

    return $f
}

proc panel:name {frame} {
    global PPxPVar

    label $frame -textvariable PPxPVar(NAME)

    return $frame
}

proc panel:set_tooltip {tooltip widget text} {
    toplevel $tooltip
    wm withdraw $tooltip
    wm overrideredirect $tooltip true

    message $tooltip.tooltipMessage -aspect 1000
    set t [option get $tooltip.tooltipMessage "text" "Text"]
    if {$text == ""} {
	set text $t
    }
    $tooltip.tooltipMessage configure -text $text
    pack $tooltip.tooltipMessage

    bind $widget <Enter> [list panel:show_tooltip_after $tooltip $widget]
    bind $widget <Leave> [list panel:hide_tooltip $tooltip $widget]
}

proc panel:show_tooltip_after {tooltip widget} {
    upvar \#0 panel_show_tooltip_$widget show_flag

    set show_flag 1
    after 500 [list panel:show_tooltip $tooltip $widget]
}

proc panel:show_tooltip {tooltip widget} {
    upvar \#0 panel_show_tooltip_$widget show_flag

    if {!$show_flag} return

    set x [winfo rootx $widget]
    set y [winfo rooty $widget]
    set h [winfo height $widget]

    set geom "+$x+[expr $y+$h]"
    wm geometry $tooltip $geom
    wm deiconify $tooltip
    raise $tooltip
}

proc panel:hide_tooltip {tooltip widget} {
    upvar \#0 panel_show_tooltip_$widget show_flag

    set show_flag 0
    if {[wm state $tooltip] == "normal"} {
	wm withdraw $tooltip
    }
}

proc panel:create_image {file} {
    global TKPPXPDIR IMAGEDIR
    image create photo -file [file join $IMAGEDIR $file]
}

proc panel:buttons {frame} {
    set f [frame $frame]

    button $f.connectButton  -image [panel:create_image start.gif]
    button $f.stopButton     -image [panel:create_image stop.gif]
    button $f.recButton      -image [panel:create_image rec.gif]
    button $f.skipButton     -image [panel:create_image skip_fw.gif]
    button $f.pauseButton    -image [panel:create_image pause.gif]
    button $f.ejectButton    -image [panel:create_image eject.gif]

    $f.connectButton configure -command {$PPxP connect}
    $f.stopButton configure -command {$PPxP disconnect}
    $f.recButton configure -command panel:pause_idle

    panel:toggle_idle_pause $f.recButton
    PPxP:UpdateVarWidget $f.recButton IDLE.MODE \
	[list panel:toggle_idle_pause $f.recButton]

    set sec [option get $f.skipButton "extendSecond" {}]
    $f.skipButton configure -command [list panel:extend_idle_time $sec]

    $f.pauseButton configure -command [list Toplevel:Close .]
    $f.ejectButton configure -command [list Toplevel:Quit .]

    panel:set_tooltip $f.connectButton.tooltip $f.connectButton {}
    panel:set_tooltip $f.stopButton.tooltip    $f.stopButton    {}
    panel:set_tooltip $f.recButton.tooltip     $f.recButton     {}
    panel:set_tooltip $f.skipButton.tooltip    $f.skipButton    {}
    panel:set_tooltip $f.pauseButton.tooltip   $f.pauseButton   {}
    panel:set_tooltip $f.ejectButton.tooltip   $f.ejectButton   {}

    set addr [panel:address $f.address]

    pack $f.connectButton $f.stopButton $f.skipButton $f.recButton \
	-side left
    pack $addr -side left -padx 2
    pack $f.ejectButton $f.pauseButton -side right

    $f configure -relief raised -borderwidth 2

    return $f
}

set panel_prev_idle_mode "pause"

proc panel:pause_idle {} {
    global PPxP PPxPVar panel_prev_idle_mode

    if {$PPxPVar(IDLE.MODE) == "pause"} {
	if {$panel_prev_idle_mode == "pause"} {
	    $PPxP set IDLE.MODE bidirectional
	} else {
	    $PPxP set IDLE.MODE $panel_prev_idle_mode
	}
    } else {
	set panel_prev_idle_mode $PPxPVar(IDLE.MODE)
	$PPxP set IDLE.MODE pause
    }
}

proc panel:toggle_idle_pause {button} {
    global PPxPVar

    if {$PPxPVar(IDLE.MODE) == "pause"} {
	$button configure -relief sunken
    } else {
	$button configure -relief raised
    }
}

proc panel:extend_idle_time {sec} {
    global PPxP PPxPInfo
    $PPxP set IDLE.TIME [expr $PPxPInfo(idle) + $sec]
}

proc panel:select_load_conf {window} {
    global PPxP

    set file [Conf:SelectDialog $window.select conf]
    if {$file != ""} {
	$PPxP source $file
	$PPxP env
    }
}

proc panel:menubar {frame} {
    set f [frame $frame -relief raised -borderwidth 2]

    menubutton $f.fileMenubutton -menu $f.fileMenubutton.menu
    set filemenu [menu $f.fileMenubutton.menu]
    $filemenu add command -command [list panel:select_load_conf $f]\
	-label "Load configuration..." -underline 0
    if {[info commands Log:Start] != ""} {
	$filemenu add command -command {Log:Start 0} \
	    -label "View Log" -underline 0
    }
    $filemenu add separator

    $filemenu add command -command [list Toplevel:Close $f] \
	-label "Bye (close console)" -underline 0
    $filemenu add command -command [list Toplevel:Quit $f] \
	-label "Quit (quit console and daemon)" -underline 0

    menubutton $f.execMenubutton -menu $f.execMenubutton.menu
    set execmenu [menu $f.execMenubutton.menu]
    $execmenu add command -command {$PPxP connect} \
	-label "Conenct" -underline 0
    $execmenu add command -command {$PPxP disconnect} \
	-label "Disconnect" -underline 0
    $execmenu add command -command {$PPxP auto} \
	-label "Auto ON" -underline 0
    $execmenu add command -command {$PPxP auto off} \
	-label "Auto OFF" -underline 6

    $execmenu add separator

    if {[info commands Qdial:Start] != ""} {
	$execmenu add command -command {Qdial:Start 0} \
	    -label "Quick Dialup" -underline 0
    }
    if {[info commands Setup:Start] != ""} {
	$execmenu add command -command {Setup:Start 0} \
	    -label "Detailed Setup" -underline 9
    }
    pack $f.fileMenubutton $f.execMenubutton -side left

    if {[info commands Cmd:CreateMenu] != ""} {
	menubutton $f.commandMenubutton -menu $f.commandMenubutton.menu
	set cmdmenu [menu $f.commandMenubutton.menu]
	Cmd:CreateMenu $cmdmenu

	pack $f.commandMenubutton -side left
    }
    return $f
}

proc panel:start_window {w args} {
    frame $w.main
    frame $w.main.f1
    frame $w.main.f2
    frame $w.main.f3

    set time	[panel:time	$w.main.timePanel]
    set status	[panel:status	$w.main.statusPanel]
    set auto	[panel:auto	$w.main.autoPanel]
    set ind	[panel:ind	$w.main.indicatorPanel]
    set name	[panel:name	$w.main.namePanel]

    pack $time   -in $w.main.f1 -side right -anchor s
    pack $auto   -in $w.main.f1 -side left  -anchor s
    pack $status -in $w.main.f2 -side left  -anchor w
    pack $name   -in $w.main.f2 -side right -anchor e
    pack $ind    -in $w.main.f3

    pack $w.main.f1 $w.main.f2 $w.main.f3 \
	-side top -fill x -expand yes

    set buttons	[panel:buttons $w.buttons]
    set menubar [panel:menubar $w.menubar]

    pack $w.menubar -side top -fill x -expand yes
    pack $w.main    -side top -fill x -expand yes -padx 5 -pady 5
    pack $w.buttons -side top -fill x -expand yes

    wm resizable [winfo toplevel .tkppxpPanel] false false
}

proc Panel:Start {main_flag} {
    Toplevel:Start .tkppxpPanel TkppxpPanel "tkPPxP" $main_flag \
	panel:start_window {}
}
