#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/wait.h>
#include <stdlib.h>

#include "config.h"
#include "support.h"

static struct job_s {
    struct job_s *next;
    char *line;
    pid_t pid;
} *jobHead, *fgJob;

static void
SigTransmit(int sig)
{
    char *name, tmp[10];

#ifdef	ONESHOT_SIGNAL
    signal(sig, SigTransmit);
#endif
    if (fgJob) {
	switch(sig) {
	case SIGINT: name = "SIGINT"; break;
	case SIGTSTP: name = "SIGTSTP"; break;
	case SIGQUIT: name = "SIGQUIT"; break;
	default:
	    sprintf(tmp, "%d", sig);
	    name = tmp;
	}
	printf("%s: %s\n", name, fgJob->line);
	if (sig == SIGTSTP) fgJob = NULL;
    }
}

static void
SigCld(int sig)
{
    int ps;
    pid_t pid;
    struct job_s *jbp, *jb1;

#ifdef	ONESHOT_SIGNAL
    signal(SIGCHLD, SigCld);
#endif
    pid = wait3(&ps, WNOHANG, 0);
    jb1 = NULL;
    jbp = jobHead;
    while (jbp) {
	if (jbp->pid == pid) {
	    if (jbp == fgJob) fgJob = NULL;
	    if (jb1) jb1->next = jbp->next;
	    else jobHead = jbp->next;
	    free(jbp->line);
	    free(jbp);
	    return;
	}
	jb1 = jbp;
	jbp = jbp->next;
    }
}

pid_t
Exec(int argc, char *argv[], char *line)
{
    pid_t pid=0;
    char *new, *old;

    old = getenv("PATH");
    new = Malloc(strlen(old) + strlen(sysPPxP)
		 + (usrPPxP ? strlen(usrPPxP): 0)
		 + sizeof("rc/:") * 2);
    if (usrPPxP) sprintf(new, "%s:%s/rc:%s/rc", old, usrPPxP, sysPPxP);
    else sprintf(new, "%s:%s/rc", old, sysPPxP);
    setenv("PATH", new, 1);
    if ((pid = fork()) == 0) {
	execvp(argv[0], argv);
	exit(0);
    } else if (pid == -1) {
	perror("fork");
    } else {
	struct job_s *jbp;

	jbp = (struct job_s *)Malloc(sizeof(struct job_s));
	fgJob = jbp;
	jbp->next = jobHead;
	jobHead = jbp;
	jbp->line = strdup(line);
	jbp->pid = pid;
    }
    return(pid);
}

int
CmdJobs(int argc, char *argv[])
{
    struct job_s *jbp=jobHead;
    int n=1;

    while(jbp) {
	printf("[%d] %s (%d)\n", n ++, jbp->line, jbp->pid);
	jbp = jbp->next;
    }
}

int
CmdFg(int argc, char *argv[])
{
    struct job_s *jbp=jobHead;

    if (argc > 1) {
	pid_t pid=0, pn=0;

	if (*argv[1] == '%') pn = atoi(argv[1] + 1);
	else pid = atoi(argv[1]);
	while(jbp) {
	    pn --;
	    if (pid) {
		if (jbp->pid == pid) break;
	    } else if (pn == 0) break;
	    jbp = jbp->next;
	}
    }
    if ((fgJob = jbp) != NULL) kill(fgJob->pid, SIGCONT);
}

void
WaitJob()
{
    if (fgJob) {
	SetTerminal(FALSE);
	while (fgJob) pause();
	SetTerminal(TRUE);
    }
}

void
InitSignals()
{
    signal(SIGINT, SigTransmit);
    signal(SIGTSTP, SigTransmit);
    signal(SIGQUIT, SigTransmit);
    signal(SIGCHLD, SigCld);
}
