
/*
Utils.h
*/

#ifndef __UTILS_H
#define __UTILS_H

#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <pwd.h>
#include <malloc.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <ctype.h>
#include <syslog.h>
#include <dirent.h>
#include <sys/times.h>                                             
#include <signal.h>

#include "Services.h"
#include "Config.h"
#include "XSocket.h"

#if defined (LINUX)
#include <asm/errno.h>
#elif defined (HP) 
#include <sys/errno.h>
#elif defined (SUN) 
#include <sys/errno.h>
#endif

#include "XString.h"
#include "XVector.h"
typedef XVector<XString> StringList;
typedef XVector<xulong> ULongList;

#define STR2(X)     #X
#define STR(X)      STR2(X)

#define CMD_HELP_LOGIN          0
#define CMD_HELP_INDEXMAILBOX   1
#define CMD_HELP_DISPLAYMSG     2
#define CMD_HELP_SHOWMAILBOXES  3
#define CMD_HELP_COMPOSEMSG     4
#define CMD_HELP_SHOWOPTIONS    5
#define CMD_HELP_ADDBOOK        6
#define CMD_HELP_SHOWATTACHS    7
#define CMD_HELP_ABOUT          8
#define CMD_HELP_AB_EDITENTRY   9
#define CMD_HELP_AB_NEWENTRY   10

#define SP ' '
#define TAB '\t'

#define CR '\015'
#define LF '\012'
#define CRLF "\015\012"

#define HTML_CR           "\n"
#define HTML_SP           "&#160;"
#define HTML_MENOR        "&#60;"
#define HTML_MAYOR        "&#62;"
#define HTML_DCOMILLAS    "&#34;"
#define HTML_HSP          "&nbsp;"
#define HTML_PORC         "&#37;"
#define HTML_SOSTENIDO    "&#35;"
#define HTML_SQU_OPEN_PAR "&#91;"
#define HTML_SQU_CLOS_PAR "&#93;"

#define HTML_nTILDE       "&ntilde;"  //241
#define HTML_NTILDE       "&Ntilde;"  //209

#define HTML_aACUTE       "&aacute;"  //225
#define HTML_aGRAVE       "&agrave;"  //224

#define HTML_eACUTE       "&eacute;"  //233
#define HTML_eGRAVE       "&egrave;"  //232

#define HTML_iACUTE       "&iacute;"  //237
#define HTML_iGRAVE       "&igrave;"  //236

#define HTML_oACUTE       "&oacute;"  //243 
#define HTML_oGRAVE       "&ograve;"  //242

#define HTML_uACUTE       "&uacute;"  //250 
#define HTML_uGRAVE       "&ugrave;"  //249

#define HTML_AACUTE       "&Aacute;"  //193
#define HTML_AGRAVE       "&Agrave;"  //192

#define HTML_EACUTE       "&Eacute;"  //201
#define HTML_EGRAVE       "&Egrave;"  //200

#define HTML_IACUTE       "&Iacute;"  //205
#define HTML_IGRAVE       "&Igrave;"  //204

#define HTML_OACUTE       "&Oacute;"  //211
#define HTML_OGRAVE       "&Ograve;"  //210

#define HTML_UACUTE       "&Uacute;"  //218
#define HTML_UGRAVE       "&Ugrave;"  //217

#define FORM_SELECT_SEPARATOR "----------"

#define ESPACIADOR "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"

#define IMAP_ERROR_FATAL (long) 1000

#define INBOX HTML_DCOMILLAS"INBOX"HTML_DCOMILLAS

//#define HTML_VERSION "3.2"
//#define HTML_DOCTYPE "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML "HTML_VERSION" Final//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">"
#define HTML_VERSION "4.01"
#define HTML_DOCTYPE "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML "HTML_VERSION" Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">"

//That is the comodin for foreign connections to Postman. This will be replaced for the correct value.
#define TOKEN_JOKER "_"

#define CONTENT_LINE_STRING "Content-length: "

#define WHITE      "#FFFFFF"
#define BLACK      "#000000"
#define RED        "#FF0000"
#define GREEN      "#00AA00"
#define BLUE       "#0000FF"
#define BLUE2      "#008080"

#define NO_SORT    1000
#define SORTTHREAD 1001

//FLAGS: only one char!
#define FRECENT      'R'
#define FNEW         'N' 
#define FUNSEEN      'U'
#define FFLAGGED     'F'
#define FANSWERED    'A'
#define FDELETED     'D'
#define FSEARCHED    '@'
#define FCOPIED      'C'
#define FEMPTY       '-'

#define POS_FLAG_DELETED   0
#define POS_FLAG_ANSWERED  1
#define POS_FLAG_NEW       2
#define POS_FLAG_IMPORTANT 3
#define POS_FLAG_SEARCHED  4
#define POS_FLAG_COPIED    5

#define CMAXHBUFFER 20000
typedef char THBuffer[CMAXHBUFFER + 1];
#define CMAXBUFFER 2000
//#define CMAXBUFFER 10000
typedef char TBuffer[CMAXBUFFER + 1];
#define CSMALLBUFFER 200
typedef char TSBuffer[CSMALLBUFFER + 1];
#define CMAXFILENAME 255
typedef char TFileName[CMAXFILENAME + 1];
#define MAXLENGTHLINE 500
typedef char LINEA [MAXLENGTHLINE + 1];
#define CMAXIPNAME 50
typedef char IPNAME [CMAXIPNAME + 1];
#define CMAXNUMBER 20
typedef char TNumber [CMAXNUMBER + 1];

#define LEN_SEP_CGI_VAR 20

#define MAXLENGTHSKIN 50
typedef int FONTSIZE;
#define MAXLENGTHFONTNAME 50
typedef char FONTNAME [MAXLENGTHFONTNAME + 1];
#define MAXLENGTHCOLORHTML 8
typedef char COLORHTML [MAXLENGTHCOLORHTML + 1];

#define MAX_FILENAME_SIZE 1024
char *get_filename(const char *str);

#define DIR_IS_WRITEABLE 0
#define DIR_IS_READONLY  1
#define DIR_IS_OVERQUOTA 2  

const char *make_random_cgi_sep (void);
void initStr (char *thestr);
char *Cut (const char *pc, int maxlong, TBuffer abuf);
bool CreateDir (const char *path, mode_t mode);
bool DeleteFile (const char *fname);
bool Touch (const char *fn);
int CreateAndLockFile (char *fn);
void EscribePIDenLockFile (int fd);
void UnlockAndCloseFile (int fd);
int IsLocked (char *fn, int *fd);
int GetPIDFromLockFile (int fd);
long GetTimeFromLockFileOpening (char *fn);
long GetTimeFromLockFile (int fd);
void SaveFileDebug (char *fn, char *pc, int len);
void SaveFileDebug (char *fn, char *pc);
char *ReturnUsersDir (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnUserDatabasesDir (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnUserLockFileName (const char *user, TBuffer ABuf);
char *ReturnUserAttachsDir (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnSignatureFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnSieveFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnSubscribedNNGroupsFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnRcNNGroupsFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnAllNNGroupsFileName (const char *server, TBuffer abuf);
char *ReturnUserOptionsFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnUserAddressbookFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnFileCalendarTemplateUser (TBuffer ABuf);
char *ReturnUserCalendarFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnUserSavedMsgFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnUserSavedNNTPMsgFileName (const char *basepath, const char *user, const char *server, TBuffer ABuf);
char *ReturnRestrictedDirNameFileBrowser (const char *basepath, const char *user, const char *server, TBuffer ABuf);
void QuitaRetornoCarroDeLinea (char *linea);
char *xstrdup (char const *str);
void Randomize ();
int Rand (int max);
char *MakeTmpName (TBuffer fntmp, int maxlong);
char *getExtensionFromFile (const char *fn);
bool FileExists (const char *fn);
int FileSize (const char *fn);
time_t FileDate (char *fn);
char *xucase (char *s);
char *xlcase (char *s);
char *xitoa (int n, TNumber abuf);
char *xltoa (long n, TNumber abuf);
int xatoidef (const char *stnum, int def);
long int xatoldef (const char *stnum, long int def);
bool xatobdef (const char *stnum, bool def);
char *make_session_id (const char *server, TBuffer abuf);
char *extract_server_from_connid (const char *connid, TBuffer Buf);
char *make_root_socket (TBuffer Buf);
char *make_session_socket (const char *username, const char *connid, TBuffer Buf);
void ini (char *connid, char *stlang, char *stcmd, char *stsubcmd, char *allparms, char *allparms2,
          char *parm1, char *parm2, char *parm3, char *parm4);
int NCstrstr (const char *linea, const char *token);
int Cstrstr (const char *linea, const char *token);
void OPENLOG (void);
void CLOSELOG (void);
void LOG (char *fmt, ...);
void LOG (long i);
void DEBUG (char *fmt, ...);
void DEBUG (int imsg);
char *FormatCountBytes (long count, TBuffer abuf);
char *FormatCountBytes1Dec (long count, TBuffer abuf);
void Redirect (const char *newurl);
void ErrorPage (const char *error);
void CGIErrorPageConnectionRefused (const char *lang);
bool CopyFile (const char *oldfile, const char *newfile);
bool CopyFileWin (const char *oldfile, const char *newfile);
bool CopyFileOverWrite (const char *oldfile, const char *newfile);
char *Text2HTML (const char *ast, char *res);
bool IsEmpty (const char *pc);
bool IsNull (const char *pc);
bool IsGoodValidator (int cmd, int validator, int validatorgood, int service, int lastservice);
void Ltrim (char *linea);
void Rtrim (char *linea);
void trim  (char *linea);
void Rclean (char *linea);
const char *ForceSpace (const char *value);
char *CutSign (const char *pc, int maxlong, const char *signal, TBuffer abuf);
char *getLineFile (const char *flname, int x, int y, TBuffer abuf);
void CreaFileSavedMsg (const char *fn);
bool ConcatLineToLineOfFile (const char *fn, int numlinea, const char *whatadd, const char *sep, int MAX);
int CountChar (char *string, char tocount);
pid_t WritePidFile (void);
void DeletePidFile (void);
void DelAllFilesFromDir (char *thedir);
char *getMailcapTipoFromFilename (const char *fn, const char *fnmailcap);
void PrintCGILoginPage (const char *lang);
void DumpHTMLPage (const char *fn, const char *progparm1, FILE *Foutput);
long min (long i,long j);
int imin (int i, int j);
void XTICK (char *label);
void PChar2SL (char *chunk, StringList *SL);
void ResaltaURLsEnText (char *txt, XSocket *aXS, int MaxLongLine, bool IsUencoded, TBuffer urltouudecode);
bool IsMultiplo (int dividendo, int divisor);
void xscanf (const char *linea, 
             char *c0,
             int *int1, int *int2, int *int3, 
             char *c1, char *c2, 
             int *int4, 
             char *c3, char *c4, char *c5, char *c6, char *c7, char *c8, char *c9);
char *ProcesaDate (char *tmp, TBuffer abuf);
int GetBufferFromFile (char *afile, char *abuf, int maxlength);
char *bool2char (bool b);
bool char2bool (char *c);
int getNumChilds (void);
int SeparaTokensEnStringList (const char *pc, const char sep, StringList *SL);
int SeparaTokensEnStringListMax (const char *pc, const char sep, int maxtokens, StringList *SL);
int CountTokensEnString (const char *pc, const char sep);
void ExtraeAddresses (StringList *SL, char *linea, bool ClearSL);
void ExtraeFullAddresses (StringList *SL, const char *linea, bool ClearSL);
bool MustDoReplayAll (const char *ato, const char *afrom, const char *areplyto, const char *acc);
char *getReplyAllAddresses (const char *ato, const char *afrom, const char *areplyto, const char *acc);
int xvsnprintf(char *str, size_t size, const char *fmt, va_list ap);
int xsnprintf(char *str, size_t size, const char *fmt, ...);
void DisableHTMLTokens (char *htmltxt);
int MergeStringList (StringList *SLBase, StringList *SL2Merge, bool check_exists);
void MEMLOG (char *LineInfo);
bool StringsLike (const char* text, const char* wildcard);
bool SavePchar (const char *pc, int len, const char *fn);
const char *cgienv_GetVarSeparator (const char *fnenv, TBuffer Sep);
const char *cgienv_GetSimpleVar (const char *fnenv, const char *EnvVarname, TBuffer abuf, bool DeleteComillas);
const char *cgienv_GetAllSimpleVarINPUTPC (const char *fnenv, TBuffer abuf, bool DeleteComillas);
void cgienv_GetAllSimpleVarINPUTSL (const char *fnenv, bool DeleteComillas, StringList *SLVars);
bool cgienv_ExistsVar (const char *fnenv, const char *EnvVarname);
bool cgienv_GetEntryBool (const char *fnenv, const char *EnvVarname);
const char *cgienv_GetSimpleVarDef (const char *fnenv, const char *EnvVarname, TBuffer abuf, TBuffer def);
const char *cgienv_GetSimpleMultipleEntries (const char *fnenv, const char *EnvVarname, const char *SEP, TBuffer abuf, bool DeleteComillas);
const char *cgienv_GetSimpleMultipleEntriesSL (const char *fnenv, const char *EnvVarname, StringList *SL, bool DeleteComillas);
const char *cgienv_GetComplexVar (const char *fnenv, const char *EnvVarname);
bool isAllowedService (StringList *aSLAllowedServices, const char *deniedservices, int aservice, const char *stservice);
char *xstrncpy (char *dest, int sizedest, const char *src);
char *xstrncat (char *dest, int sizedest, const char *src);
const char LastChar (const char *string);
const char FirstChar (const char *string);
int CompareStringsNCS (const void *e1, const void *e2);
int CompareStringsCS (const void *e1, const void *e2);
void FlipStrings (const void *e1, const void *e2);
void ReverseSL (StringList *SL);
void ExpandString (char *linea, int size, const char *internal, const char *server, const char *username, const char *password, const char *user_home);
bool IsSameFileSystem (const char *ori_fullfilename, const char *des_fullfilename);
int xrename (const char *ori_fullfilename, const char *des_fullfilename);
long getHardDiskUsage (const char *dirname, TBuffer ErrorMsg);
char *delLastSlash (char *apath);
char *addLastSlash (char *apath);
bool CheckServiceDisabled (const char *service, TBuffer file2show);
char *QuitaComillas (char *token);
char *getTrueAllParms (const char *REQUEST_URI, TBuffer trueallparms);
int IsDirWriteable (const char *directory);
char *c2x (unsigned char letra, TNumber anum);
char *escape_url (const char *source, TBuffer dest);
void utils_unescape (char *value);
int CountChars (const char *line, const char c);
void getConnidFromCookie (TBuffer cookiestring);
void CGIErrorPage (const char *lang, int MSG_ERROR);
void CGIPageConnectionToService (const char *lang, const char *imapserver, const char *user, const char *stservice, const char *stcmd, const char *stsubcmd,
                                 const char *parm1, const char *parm2, const char *parm3, const char *parm4);

#endif
